/* $Id: dlgAdvanced.cpp,v 1.1.1.1 1999/02/10 18:16:34 koss Exp $
   $Log: dlgAdvanced.cpp,v $
   Revision 1.1.1.1  1999/02/10 18:16:34  koss
   Imported sources

   Revision 1.1  1999/02/07 17:11:28  matt
   source entered


   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include <qlayout.h>

#include <kapp.h>
#include <kio_manager.h>

#include "dlgAdvanced.h"

extern QString getStringFromBool( bool x );
extern bool getBoolFromString( QString s );

DlgAdvanced::DlgAdvanced(QWidget *parent, const char *name, WFlags f)
  : QWidget(parent, name, f)
{

  QVBoxLayout *topLayout = new QVBoxLayout( this, 10, 5 );
  topLayout->addSpacing( 5 );

  gb_advanced = new QGroupBox(this, "gb_advanced");
  gb_advanced->setTitle(i18n("Advanced Options"));
  topLayout->addWidget( gb_advanced, 10 );

  QGridLayout *gridLayout = new QGridLayout( gb_advanced, 8, 5, 5 );

  gridLayout->addRowSpacing(0,10);
  gridLayout->addRowSpacing(7,10);

  gridLayout->addColSpacing(0,5);
  gridLayout->addColSpacing(4,5);

  gridLayout->setRowStretch(0,5);
  gridLayout->setRowStretch(1,10);
  gridLayout->setRowStretch(2,10);
  gridLayout->setRowStretch(3,10);
  gridLayout->setRowStretch(4,10);
  gridLayout->setRowStretch(5,10);
  gridLayout->setRowStretch(6,10);
  gridLayout->setRowStretch(7,5);
    
  gridLayout->setColStretch(0,2);
  gridLayout->setColStretch(1,10);
  gridLayout->setColStretch(2,5);
  gridLayout->setColStretch(3,5);
  gridLayout->setColStretch(4,2);

  // adding new transfers
  lb_adding = new QLabel(i18n("Add new transfers as"), gb_advanced);
  gridLayout->addWidget( lb_adding, 1, 1 );

  bg_adding = new QButtonGroup();

  rb_queued = new QRadioButton( i18n("Queued"), gb_advanced );
  bg_adding->insert( rb_queued );
  gridLayout->addWidget( rb_queued, 1, 2 );

  rb_delayed = new QRadioButton( i18n("Delayed"), gb_advanced );
  bg_adding->insert( rb_delayed );
  gridLayout->addWidget( rb_delayed, 1, 3 );

  //
  cb_downloadwindows = new QCheckBox( i18n("Show download windows"), gb_advanced );
  gridLayout->addWidget( cb_downloadwindows, 2, 1 );

  cb_iconify = new QCheckBox( i18n("iconified"), gb_advanced );
  gridLayout->addWidget( cb_iconify, 2, 2 );

  connect( cb_downloadwindows, SIGNAL(toggled(bool)),cb_iconify, SLOT(setEnabled(bool)) );

  //
  cb_partial = new QCheckBox( i18n("Mark partial downloads"), gb_advanced );
  gridLayout->addMultiCellWidget( cb_partial, 3, 3, 1, 3 );

  //
  cb_remove = new QCheckBox( i18n("Remove files from a list after success"),
			     gb_advanced );
  gridLayout->addMultiCellWidget( cb_remove, 4, 4, 1, 3 );

  //
  cb_getsizes = new QCheckBox( i18n("Get file sizes"), gb_advanced );
  gridLayout->addMultiCellWidget( cb_getsizes, 5, 5, 1, 3 );

  //
  //  cb_usecookies = new QCheckBox( i18n("Use cookies from web server"), gb_advanced );
  //  gridLayout->addMultiCellWidget( cb_usecookies, 6, 6, 1, 3 );

  //
  cb_expertmode = new QCheckBox(i18n("Expert mode ( don't prompt for cancel or delete )"),
			     gb_advanced );
  gridLayout->addMultiCellWidget( cb_expertmode, 6, 6, 1, 3 );

  //
  gridLayout->activate();

  topLayout->addSpacing( 5 );
  topLayout->activate();
}


DlgAdvanced::~DlgAdvanced()
{
  delete bg_adding;
}


void DlgAdvanced::setData(QStrList *strList)
{
  bool tmp = getBoolFromString( strList->first() );
  rb_queued->setChecked( tmp );
  rb_delayed->setChecked( !tmp );

  bool downloadWindows = getBoolFromString( strList->next() );
  cb_iconify->setEnabled( downloadWindows );
  cb_downloadwindows->setChecked( downloadWindows );

  cb_iconify->setChecked( getBoolFromString( strList->next() ) );
  cb_remove->setChecked( getBoolFromString( strList->next() ) );
  cb_getsizes->setChecked( getBoolFromString( strList->next() ) );
  //  cb_usecookies->setChecked( getBoolFromString( strList->next() ) );
  cb_expertmode->setChecked( getBoolFromString( strList->next() ) );

  cb_partial->setChecked( ProtocolManager::self()->getMarkPartial() );
}


static QStrList strList(true);


QStrList DlgAdvanced::getData() const
{
  strList.clear();

  strList.append( getStringFromBool( rb_queued->isChecked() ) );
  strList.append( getStringFromBool( cb_downloadwindows->isChecked() ) );
  strList.append( getStringFromBool( cb_iconify->isChecked() ) );
  strList.append( getStringFromBool( cb_remove->isChecked() ) );
  strList.append( getStringFromBool( cb_getsizes->isChecked() ) );
  //  strList.append( getStringFromBool( cb_usecookies->isChecked() ) );
  strList.append( getStringFromBool( cb_expertmode->isChecked() ) );

  ProtocolManager::self()->setMarkPartial( cb_partial->isChecked() );

  return strList;
}
