##############################################################################
#                                                                            #
# kftpupdater - Mirror a local directory to an ftp server or vice versa      #
# Copyright (C) 2000 Martin P. Holland  <m.holland@noether.freeserve.co.uk>  #
#                                                                            #
# This program is free software; you can redistribute it and/or modify       #
# it under the terms of the GNU General Public License as published by       #
# the Free Software Foundation; either version 2 of the License, or          #
# (at your option) any later version.                                        #
#                                                                            #
# This program is distributed in the hope that it will be useful,            #
# but WITHOUT ANY WARRANTY; without even the implied warranty of             #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              #
# GNU General Public License for more details.                               #
#                                                                            #
# You should have received a copy of the GNU General Public License          #
# along with this program; if not, write to the Free Software                #
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA  #
#                                                                            #
##############################################################################
#blocksize for ftp put operation
BLK=8192
StopError='stop_error'
#import ftplib
from qt import *

from kdeui import *
from kfile import *
from kdecore import *

from update import Update, error_proto
from namedialog import nameDialog
from projectdialog2 import projectDialog2
from status import *
import time, os, ConfigParser, tempfile, thread
from stat import *

class View(QListBox):
    def __init__ (self,parent,name,config,proj_name):
        "Main window class constructor"
        QListBox.__init__(self,parent,name)
        self.setFocusPolicy(QWidget.FocusPolicy.StrongFocus)
        self.setFocus()
        self.parent=parent
        self.config=config
        if self.config==None:
            self.config=os.path.expanduser("~")+'/update.config'
        self.name=proj_name
        p=ConfigParser.ConfigParser()
        p.read(self.config)
        self.projects=p.sections()
        if self.name!=None:
            self.process_config()
        self.setLock(0)

    def test(self):
# the problem with using KFM is that it plasters the password on
# the screen. Duh!
#        import kfm
#        s=QString()
#        k=kfm.KFM()
#        print k.download("ftp://martin:passwd@localhost/home/martin/noether/index.html",s)
#        os.system("cp "+str(s)+" foo.html")
#        k.removeTempFile(s)
        from projectdialog2 import projectDialog2
        projectDialog2(self,'',self.name,0)
        print self.__dialog_ok

    def dialogSuccess(self,n):
        self.__dialog_ok=n

    def freshen(self):
        #process events
        app=KApplication.getKApplication()
        app.processEvents()

    def focusOutEvent(self,e):  #these are implemented as pass
        "focus out"             #to stop unneeded updates
        pass

    def focusInEvent(self,e):
        "focus in"
        pass

    def newconfig(self):
        "New config file"
        if self.isLocked(): return
        ans=str(KFileDialog.getSaveFileName())
        if ans==None or ans=='':
            self.releaseLock()
            return
        self.config=ans
        self.blank_project()
        p=ConfigParser.ConfigParser()
        p.read(self.config)
        self.projects=p.sections()
        if self.name!=None:
            self.process_config()

    def oldnew(self):
        "new project"
        nd=nameDialog(self,'')
        if nd.result():
            self.name=nd.return_name()
        else: return
        pd=projectDialog(self,'',self.name,1)
        if pd.result() and pd.writeconfig():
            self.parent.statusChange(self.name,ID_PROJECT)
            self.process_config()
            p=ConfigParser.ConfigParser()
            p.read(self.config)
            self.projects=p.sections()
            self.parent.rereadmenus()
        else: self.blank_project()

    def new(self):
        "new project"
        if self.isLocked(): return
        nd=nameDialog(self,'')
        if nd.result():
            self.name=nd.return_name()
        else: return
        pd=projectDialog2(self,'',self.name,1)
        if self.__dialog_ok:
            self.parent.statusChange(self.name,ID_PROJECT)
            self.process_config()
            p=ConfigParser.ConfigParser()
            p.read(self.config)
            self.projects=p.sections()
            self.parent.rereadmenus()
        else: self.blank_project()

    def oldedit(self,i):
        "edit project"
        pd=projectDialog(self,'',self.projects[i],0)
        if pd.result() and pd.writeconfig():
            self.name=self.projects[i]
            self.parent.statusChange(self.name,ID_PROJECT)
            self.process_config()
        else: self.blank_project()

    def edit(self,i):
        "edit project"
        if self.isLocked(): return
        pd=projectDialog2(self,'',self.projects[i],0)
        if self.__dialog_ok:
            self.name=self.projects[i]
            self.parent.statusChange(self.name,ID_PROJECT)
            self.process_config()
        else: self.blank_project()

    def edit_current(self):
        if self.isLocked(): return
        if self.name==None:
            self.parent.statusMessage("No current project",2000)
            return
        self.edit(self.projects.index(self.name))
        
    def del_proj(self,i):
        "delete project"
        if self.isLocked(): return
        project=self.projects[i]
        ans=KMsgBox.yesNo(self.parent,i18n("ftpupdater: Warning"),i18n("Are you sure you want to delete ")+project)
        if ans==2:
            #this means No
            return
        p=ConfigParser.ConfigParser()
        p.read(self.config)
        projects=p.sections()
        head,tail=os.path.split(self.config)
        tail=tail+".tmp"
        tmp=os.path.join(head,tail)
#        f=open(self.config,'w')
        f=open(tmp,'w')
        os.chmod(tmp,0600)
#        os.chmod(self.config,0600)
        for proj in projects:
            if proj==project: continue
            f.write('['+proj+']\n')
            for opt in p.options(proj):
                if opt=="name" or opt=="__name__": continue
                f.write(opt+'='+p.get(proj,opt)+'\n')
        f.close()
        os.rename(tmp,self.config)
        del self.projects[i]
        self.parent.rereadmenus()
        if project==self.name:
            self.blank_project()

    def blank_project(self):
        self.name=None
        self.parent.statusChange("No Project",ID_PROJECT)

    def process_config(self):
        "read config for current project"
        self.update=Update(self.name,self.config) #name, config file
        if not self.update.readconfig():
            self.pr("Broken config file "+self.config+" for "+self.name)
            self.blank_project()
        else:
            self.update.pr=self.pr
            self.parent.statusChange(self.name,ID_PROJECT)

    def initdb(self):
        "create time stamps database"
        if self.isLocked(): return
        if self.name==None:
            self.parent.statusMessage("No current project",2000)
            return
        if self.update.put:
            self.update.init_transfer(noftplogin=1)
        else:
            if not self.update.initftp():
                self.pr(self.update.error)
                return
            self.update.init_transfer()
        self.update.empty_db()
        self.pr("Creating time stamps database...")
        if not self.update.init_db():
            self.pr(self.update.error)
        self.pr("done")
        if not self.update.put: self.update.ftpQuit()

    def pr(self,s=''):
        "print to the scroll window."
        #This is used to override a function in update
        if type(s)!=type(()):
            s=[s]
        for item in s:
            self.insertItem(str(item))
        self.freshen() #keep the GUI nice and snappy ;-)

    def initProgress(self,filename):
        "Create a progress bar for FILENAME's transfer."
#        print filename
        self._size=self.update.xfer.size(filename)
        self._count=0
        self.progress=QProgressDialog(filename,"Abort",self._size,self,"kftpupdater")
        self.progress.setCaption("kftpupdater: transferring ...")
        self.progress.setMinimumDuration(1000)
        self.progress.setProgress(0)
        
    def doProgress(self,n):
        if self.progress.wasCancelled():
            self.update.stop()
        if self.update.isStopped():
            if not self.progress.wasCancelled():
                self.finishProgress()
            raise error_proto, "User stopped transfer"
        self._count=self._count+n
        self.progress.setProgress(self._count)
        
    def finishProgress(self):
        self.progress.setProgress(self._size)

    def yesno(self,f):
        return KMsgBox.yesNo(self, "Kftpupdater", "Are you sure you want to delete "+f+"?")

    def dryrun(self):
        "dry run"
        if self.isLocked(): return
        self.update.setDry(1)
        try:
            self.transfer()
        except:
            #bare except because I don't want to retain dry run
            import traceback
            self.pr("Uh oh! something went wrong with the dry run")
            traceback.print_exc()
        self.update.setDry(0)
        self.releaseLock()

    def transfer(self):
        "transfer files"
        if self.isLocked(): return
        self.getLock()
        try:
            #I need to catch any errors so I can release the lock
            if self.name==None:
                self.parent.statusMessage("No current project",2000)
                self.releaseLock()
                return
            if not self.update.initftp():
                self.pr(self.update.error)
                self.releaseLock()
                return
            self.update.init_transfer()
            self.update.setProgress(self.initProgress,self.doProgress,self.finishProgress)
            self.update.setEvent(self.freshen)
            if not self.update.readdb():
                self.pr(self.update.error)
                self.pr("You need to create a time stamps database.")
                self.update.ftpQuit()
                self.releaseLock()
                return
    #        thread.start_new_thread(self.update.init,())
    #        print "exit"
            if not self.update.isDry():
                self.update.setConfirmDel(self.confirmDel)
            else:
                self.update.setConfirmDel(0)
            if self.update.isConfirmDel():
                self.update.setYesno(self.yesno)
            self.update.init()
            self.releaseLock()
        except:
            import traceback
            self.pr("Uh oh! something went wrong with the transfer")
            traceback.print_exc()
            self.releaseLock()

    def force(self):
        "tranfer files regardless of time stamps"
        if self.isLocked(): return
        self.getLock()
        try:
            if self.name==None:
                self.parent.statusMessage("No current project",2000)
                self.releaseLock()
                return
            if not self.update.initftp():
                self.pr(self.update.error)
                self.releaseLock()
                return
            self.update.init_transfer()
            self.update.setProgress(self.initProgress,self.doProgress,self.finishProgress)
            self.update.setEvent(self.freshen)
            if not self.update.cleardb():
                self.pr(self.update.error)
                self.update.ftpQuit()
                self.releaseLock()
                return
            self.update.setConfirmDel(self.confirmDel)
            if self.update.isConfirmDel():
                self.update.setYesno(self.yesno)
            self.update.init()
            self.releaseLock()
        except:
            import traceback
            self.pr("Uh oh! something went wrong with the forced run")
            traceback.print_exc()
            self.releaseLock()

    def setName(self,i):
        "open a project"
        if self.isLocked():return
        self.name=self.projects[i]
        self.parent.statusChange(self.name,ID_PROJECT)
        self.process_config()

    def getLock(self):
        self._lock=1
        self.parent.enableStop(1)

    def setLock(self,n):
        self._lock=n

    def releaseLock(self):
        self._lock=0
        self.parent.enableStop(0)
        self.update.stop(0)
        
    def isLocked(self):
        if self._lock:
            self.parent.statusMessage("Currently executing a command",2000)
        return self._lock

    def stop(self):
        if self._lock:
            self.update.stop()
        else:
            self.parent.statusMessage("No transfer underway to interrupt",2000)
            