#ifndef __ONMEDIAPAGE_H__
#define __ONMEDIAPAGE_H__

#include <qwidget.h>
#include <qbttngrp.h> 
#include <qgrpbox.h>
#include <qmlined.h>
#include <qlined.h>
#include <qlayout.h> 
#include <qchkbox.h> 
#include <qdict.h>
#include <qstrlist.h>
#include <qlabel.h>
#include <qradiobt.h> 
#include "kintegerline.h"
#include "ktablistbox.h"

#include "ircClient.h"
#include <kconfig.h>

class OnMediaPage : public QWidget
{
  Q_OBJECT
protected:
  IrcClient*   client;
  KTabListBox* playerBox;

  QHBoxLayout* horLayout;
  QVBoxLayout* lVerLayout;
  QVBoxLayout* rVerLayout;

public:
  OnMediaPage(IrcClient* Client, QWidget *parent = NULL, const char *name = NULL );
  ~OnMediaPage();
protected:
  void    readConfig();
  void    createButton();
  void    createPlayerBox();
  bool    checkItem(QString s);
protected slots:
  void slotAdd();
  void slotEdit();
  void slotDelete();
  void slotApply();
};

#endif
