#ifndef __IRCEDIT_H__
#define __IRCEDIT_H__

#include <qframe.h>
#include <qaccel.h>
#include <qmsgbox.h>
#include <ktopwidget.h>
#include <kconfig.h>
#include <kstatusbar.h>
#include <qdict.h>
#include "ircMultiLine.h"

class IrcEdit : public KTopLevelWidget
{
    Q_OBJECT;
protected:
    QString name;
public:
    IrcEdit(const char* name=0L, const char* file=0L);
    virtual ~IrcEdit();
public slots:
     void slotFileNew()  ;
     void slotFileOpen();
     void slotFileSave();
     void slotFileSaveAs();
     void slotFileExit() ;

protected:
     void closeEvent (QCloseEvent*  e);
     void resizeEvent(QResizeEvent* e);
private:
     void createMenu();
     void createStatusbar();

private:
     IrcMultiLine*      view;
     KMenuBar*          menubar;
     KStatusBar*        statusbar;

     QDict<QPopupMenu>  menu;

     int idFileNew;
     int idFileOpen;
     int idFileSave;
     int idFileSaveAs;
     int idFileExit;

     int  idSbLine;
};

#endif





