#include <iostream.h>
#include "StringToken.h"
#include "IrcSocket.h"
#include "IrcSocket.moc"

SendTab IrcSocket::sendTab[]={
    {"PASS",   IrcSocket::sendPass   },
    {"NICK",   IrcSocket::sendNick   },
    {"OPER",   IrcSocket::sendOper   },
    {"QUIT",   IrcSocket::sendQuit   },
    {"SQUIT",  IrcSocket::sendSQuit  },
    {"JOIN",   IrcSocket::sendJoin   },
    {"PART",   IrcSocket::sendPart   },
    {"MODE",   IrcSocket::sendMode   },
    {"TOPIC",  IrcSocket::sendTopic  },
    {"NAMES",  IrcSocket::sendNames  },
    {"LIST",   IrcSocket::sendList   },
    {"INVITE", IrcSocket::sendInvite },
    {"KICK",   IrcSocket::sendKick   },
    {"VERSION",IrcSocket::sendVersion},
    {"STATS",  IrcSocket::sendStats  },
    {"LINKS",  IrcSocket::sendLinks  },
    {"TIME",   IrcSocket::sendTime   },
    {"CONNECT",IrcSocket::sendConnect},
    {"TRACE",  IrcSocket::sendTrace  },
    {"ADMIN",  IrcSocket::sendAdmin  },
    {"INFO",   IrcSocket::sendInfo   },
    {"PRIVMSG",IrcSocket::sendPrivmsg},
    {"NOTICE", IrcSocket::sendNotice },
    {"WHO",    IrcSocket::sendWho    },
    {"WHOIS",  IrcSocket::sendWhois  },
    {"WHOWAS", IrcSocket::sendWhowas },
    {"KILL",   IrcSocket::sendKill   },
    {"PING",   IrcSocket::sendPing   },
    {"PONG",   IrcSocket::sendPong   },
    {"AWAY",   IrcSocket::sendAway   },
    {"REHASH", IrcSocket::sendRehash },
    {"RESTART",IrcSocket::sendRestart},
    {"SUMMON", IrcSocket::sendSummon },
    {"USERS",  IrcSocket::sendUsers  },
    {"WALLOPS",IrcSocket::sendWallops},
    {"USERHOST",IrcSocket::sendUserhost},
    {"ISON",   IrcSocket::sendIson   },
    {"RAW",    IrcSocket::sendRaw    },
    {"CTCP",   IrcSocket::sendCtcp   },
    {"CTCPREPLY",  IrcSocket::sendCtcpReply   },
    {NULL,    NULL}
  };


// Konstruktor
IrcSocket::IrcSocket() : Socks()
{
}

IrcSocket::IrcSocket(IrcServer* server) : Socks(server->Host(), server->Port().toInt())
{
}

IrcSocket::IrcSocket(const char* host, int port) : Socks(host, port)
{
}

IrcSocket::~IrcSocket()
{
}

int IrcSocket::Open(IrcServer* server)
{
  return ClientSocket::Open(server->Host(), server->Port().toInt());
}

int IrcSocket::Open(const char* host, int port)
{
  return ClientSocket::Open(host, port);
}

int IrcSocket::parseLine(const char* txt)
{
#ifdef EDEBUG
  cout << "IrcSocket::parseline:"<<txt<<endl;
#endif
  if (!txt)
     return 0;
  StringToken token(txt, " ");
  QString cmd;
  cmd = token.nextToken();
  for (int i=0;sendTab[i].name!=NULL;i++){
      if (!stricmp(cmd,sendTab[i].name)){
	 QString t=token.toEnd("\n");
	 return (this->*(sendTab[i].func))(t);
      }
  }
  return 0;
}

// Connection Registration
int IrcSocket::sendPass(const char* txt)
{
  QString t=txt;
  if (t.isNull())
     return 0;
  QString s="PASS "+t;
  return writeLine(s);
}

int IrcSocket::sendNick(const char* txt)
{
  QString t=txt;
  if (t.isNull())
     return 0;
  QString s="NICK "+t;
  return writeLine(s);
}

int IrcSocket::sendUser(const char* txt)
{
  QString t=txt;
  if (t.isNull())
     return 0;
  QString s="USER "+t;
  return writeLine(s);
}

int IrcSocket::sendOper(const char* txt)
{
  QString t=txt;
  if (t.isNull())
     return 0;
  QString s="OPER "+t;
  return writeLine(s);
}

int IrcSocket::sendQuit(const char* txt)
{
  QString t=txt;
  if (t.isNull())
     return 0;
  QString s="QUIT :"+t;
  return writeLine(s);
}

int IrcSocket::sendSQuit(const char* txt)
{
  QString t=txt;
  if (t.isNull())
     return 0;
  QString s="SQUIT "+t;
  return writeLine(s);
}

// Channel operations
int IrcSocket::sendJoin(const char* txt)
{
  QString t=txt;
  if (t.isNull())
     return 0;
  QString s="JOIN "+t;
  return writeLine(s);
}

int IrcSocket::sendPart(const char* chan)
{
  QString c=chan;
  if (c.isNull())
     return 0;
  QString s="PART "+c;
  int id = writeLine(s);
  return id;
}

int IrcSocket::sendMode(const char* txt)
{
  QString t=txt;
  if (t.isNull())
     return 0;
  QString s="MODE "+t;
  return writeLine(s);
}

int IrcSocket::sendTopic(const char* txt)
{
  if (!txt)
     return 0;
  StringToken token(txt);
  QString c=token.nextToken();
  QString t=token.toEnd("\n");
  t.remove(0, 1);
  QString s="TOPIC "+c;
  if (!t.isEmpty())
     s +=" :"+t;
  return writeLine(s);
}

int IrcSocket::sendNames(const char* chan)
{
  QString c=chan;
  if (c.isNull())
     return 0;
  QString s="NAMES "+c;;
  return writeLine(s);
}

int IrcSocket::sendList(const char* txt)
{
  QString t=txt;
  if (t.isNull())
     t="";
  QString s="LIST "+t;
  return writeLine(s);
}

int IrcSocket::sendInvite(const char* txt)
{
  if (!txt)
     return 0;
  QString t=txt;
  QString s="INVITE "+t;
  return writeLine(s);
}

int IrcSocket::sendKick(const char* txt)
{
  if (!txt)
     return 0;
  StringToken token(txt);
  QString c=token.nextToken();
  QString u=token.nextToken();
  QString t=token.toEnd("\n");
  t.remove(0, 1);
  QString s="KICK "+c+" "+u+" :"+t;
  return writeLine(s);
}

// Server queries and commands
int IrcSocket::sendVersion(const char* txt)
{
  QString t=txt;
  if (t.isNull())
     return 0;
  QString s="VERSION "+t;
  return writeLine(s);
}

int IrcSocket::sendStats(const char* txt)
{
  QString t=txt;
  if (t.isNull())
     return 0;
  QString s="STATS "+t;
  return writeLine(s);
}

int IrcSocket::sendLinks(const char* txt)
{
  QString t=txt;
  if (t.isNull())
     return 0;
  QString s="LINKS "+t;
  return writeLine(s);
}

int IrcSocket::sendTime(const char* txt)
{
  QString t=txt;
  if (t.isNull())
     return 0;
  QString s="TIME "+t;
  return writeLine(s);
}

int IrcSocket::sendConnect(const char* txt)
{
  QString t=txt;
  if (t.isNull())
     return 0;
  QString s="CONNECT "+t;
  return writeLine(s);
}

int IrcSocket::sendTrace(const char* txt)
{
  QString t=txt;
  if (t.isNull())
     return 0;
  QString s="TRACE "+t;
  return writeLine(s);
}

int IrcSocket::sendAdmin(const char* txt)
{
  QString t=txt;
  if (t.isNull())
     return 0;
  QString s="ADMIN "+t;
  return writeLine(s);
}

int IrcSocket::sendInfo(const char* txt)
{
  QString t=txt;
  if (t.isNull())
     return 0;
  QString s="INFO "+t;
  return writeLine(s);
}

int IrcSocket::sendPrivmsg(const char* txt)
{
  QString t=txt;
  if (t.isEmpty())
     return 0;
  StringToken token(txt);
  QString u=token.nextToken();
  QString m=token.toEnd("\n");
  m.remove(0, 1);
  QString s="PRIVMSG "+u+" :"+m;
  int id = writeLine(s);
  return id;
}

int IrcSocket::sendNotice(const char* txt)
{
  QString t=txt;
  if (t.isEmpty())
     return 0;
  StringToken token(txt);
  QString u=token.nextToken();
  QString m=token.toEnd("\n");
  m.remove(0, 1);
  QString s="NOTICE "+u+" :"+m;
  return writeLine(s);
}

// User based query
int IrcSocket::sendWho(const char* txt)
{
  QString t=txt;
  if (t.isNull())
     return 0;
  QString s="WHO "+t;
  return writeLine(s);
}

int IrcSocket::sendWhois(const char* txt)
{
  QString t=txt;
  if (t.isNull())
     return 0;
  QString s="WHOIS "+t;
  return writeLine(s);
}

int IrcSocket::sendWhowas(const char* txt)
{
  QString t=txt;
  if (t.isNull())
     return 0;
  QString s="WHOWAS "+t;
  return writeLine(s);
}

// Miscellaneous messages
int IrcSocket::sendKill(const char* txt)
{
  QString t=txt;
  if (t.isNull())
     return 0;
  QString s="KILL "+t;
  return writeLine(s);
}

int IrcSocket::sendPing(const char* txt)
{
  QString t=txt;
  if (t.isNull())
     return 0;
  QString s="PING "+t;
  return writeLine(s);
}

int IrcSocket::sendPong(const char* txt)
{
  QString t=txt;
  if (t.isNull())
     return 0;
  QString s="PONG "+t;
  return writeLine(s);
}

// Optionals
int IrcSocket::sendAway(const char* txt)
{
  QString t=txt;
  if (t.isNull())
     t="";
  StringToken token(t);
  t=token.toEnd("\n");
  t.remove(0, 1);
  QString s="AWAY";
  if (!t.isEmpty())
     s +=" :"+t;
  return writeLine(s);
}

int IrcSocket::sendRehash(const char*)
{
  QString s="REHASH ";
  return writeLine(s);
}

int IrcSocket::sendRestart(const char*)
{
  QString s="RESTART ";
  return writeLine(s);
}

int IrcSocket::sendSummon(const char* txt)
{
  QString t=txt;
  if (t.isNull())
     t="";;
  QString s="SUMMON "+t;
  return writeLine(s);
}

int IrcSocket::sendUsers(const char* txt)
{
  QString t=txt;
  if (t.isNull())
     t="";

  StringToken token(t);
  t=token.toEnd();
  QString s="USERS";
  if (!t.isEmpty())
     s +=" :"+t;
  return writeLine(s);
}

int IrcSocket::sendWallops(const char* txt)
{
  QString t=txt;
  if (t.isNull())
     t="";
  StringToken token(t);
  t=token.toEnd();
  QString s="WALLOPS";
  if (!t.isEmpty())
     s +=" :"+t;
  return writeLine(s);
}

int IrcSocket::sendUserhost(const char* txt)
{
  QString t=txt;
  if (t.isNull())
     t="";
  QString s="USERHOST "+t;
  return writeLine(s);
}

int IrcSocket::sendIson(const char* txt)
{
  QString t=txt;
  if (t.isNull())
     return 0;
  QString s="ISON "+t;
  return writeLine(s);
}

int IrcSocket::sendRaw(const char* txt)
{
  QString t=txt;
  if (t.isNull())
     return 0;
  return writeLine(t);
}

int IrcSocket::sendCtcp(const char* txt)
{
  QString t=txt;
  if (t.isNull())
     return 0;
  StringToken token(txt);
  QString u=token.nextToken();
  QString m=token.toEnd("\n");
  m.remove(0, 1);
  QString s="PRIVMSG "+u+" :"+0x01+m+0x01;
#ifdef EDEBUG
  cout << "IrcSocket::sendCtcp:"<<s<<endl;
#endif
  return writeLine(s);
}

int IrcSocket::sendCtcpReply(const char* txt)
{
  QString t=txt;
  if (t.isNull())
     return 0;
  StringToken token(txt);
  QString u=token.nextToken();
  QString m=token.toEnd("\n");
  m.remove(0, 1);
  QString s="NOTICE "+u+" :"+0x01+m+0x01;
#ifdef EDEBUG
  cout << "IrcSocket::sendCtcpReply:"<<s<<endl;
#endif
  return writeLine(s);
}





