#include <iostream.h>
#include "ircView.h"
#include "privMsgView.h"
#include "privMsgView.moc"
#include "optPrefDialog.h"
#include "privMsgPage.h"
#include "fontOpt.h"
#include "colorOpt.h"


PrivMsgView::PrivMsgView(IrcClient* client, QWidget* parent, const char* name ) : 
             PageTab(client, parent, name)
{
   this->client = client;
   setFrameStyle(QFrame::Panel | QFrame::Sunken);
   setLineWidth (2);
   connect(client, 
	  SIGNAL(signAddPrivMsg(const char*)),
	  this,
	  SLOT  (slotAddPrivMsg(const char*)));

   show();
}

PrivMsgView::~PrivMsgView()
{
#ifdef EDEBUG
  cout << "Destruktor PrivMsgView" << endl;
#endif
}

void PrivMsgView::slotAddPrivMsg(const char* Name)
{
  if (!Name)
     return;
#ifdef EDEBUG
  cout << "PrivMsgView::slotAddPrivMsg:" << Name<<endl;
#endif
  slotDelPage(Name);
  PrivMsgPage* pp;
  
  QString s=Name;
  treeList->insertItem(s, 0, treeList->currentItem());
  pageWidget->hide();

  QString  value;
  value = ircapp->readEntry("PrivMsgWindowDetach", "No");
  if (value.find( "No", 0, false ) == 0){
     pp=new PrivMsgPage(client, pageWidget, Name);
     pp->vbox = new QVBoxLayout(pageWidget,0);
     pp->vbox->addWidget(pp);
     pp->vbox->activate();
  }
  else{
     pp=new PrivMsgPage(client, 0L, Name);
     pp->setCaption(Name);
     pp->show();
  }

  pageWidget->show();
  page->insert(Name, pp);
  OptPrefDialog* dlg=client->optPrefDlg;
  
  connect(pp->getClient(), 
	  SIGNAL(signDelClient(const char*)),
	  this,
	  SLOT  (slotDelPage  (const char*)));
  connect(pp->getClient(), 
	  SIGNAL(signChangeNick(const char*, const char*)),
	  this,
	  SLOT  (slotChangeItemName(const char*, const char*)));
  connect(this,
	  SIGNAL(signCurrentPage(const char*)),
	  pp,
	  SLOT  (slotCurrentPage(const char*)));
    connect(pp,
	  SIGNAL(signDetach(bool, const char*)),
	  this,
	  SLOT  (slotDetach(bool, const char*)));

  QWidget* w=topLevelWidget();
  if (!w->isVisible())
     w->show();

  
  KTreeListItem* item;
  for (int i=0;i<treeList->count();i++){
     item = treeList->itemAt(i);
     if (!stricmp(Name, item->getText())){
        slotSetPage(i);
	return;
     }
  }
}


void PrivMsgView::closeEvent (QCloseEvent *)
{
#ifdef EDEBUG
  cout << "PrivMsgView::CloseEvent" << endl;
#endif
}


void PrivMsgView::slotDetach(bool detach, const char* name)
{
  ircapp->writeEntry( "PrivMsgWindowDetach",   detach ? "Yes" : "No" );
  PageTab::slotDetach(detach, name);
}











