#include <stdlib.h>
#include <iostream.h>
#include <qlined.h>
#include <qfiledlg.h> 
#include <qfileinf.h> 
#include <qtooltip.h> 
#include "fileReader.h"
#include <qpushbt.h>
#include <qlabel.h>
#include <qframe.h>
#include <qlayout.h>
#include "ircDefine.h"
#include "onKickPage.h"
#include "onKickPage.moc"
#include "ircBell.h"
#include "ircApp.h"

void OnKickPage::Init()
{
  btnGroup.setAutoDelete(false);
  radioBtn.setAutoDelete(false);
  groupBox.setAutoDelete(false);
  intLine.setAutoDelete (false);

  configText.setAutoDelete(true);
  actionText.setAutoDelete(true);
}

OnKickPage::OnKickPage(IrcClient* client, QWidget *parent, const char *name ) : 
  QWidget( parent, name )
{
  Init();
  this->client=client;
  
  topLayout = new QVBoxLayout(this, 10);
  grid      = new QGridLayout(2, 2, 10);
  topLayout->addLayout(grid);

  createActionRadioBtn();
  createConfigBox();
  createPushButton();

  IrcBell* ib;
  QString  es="KickBell";
  client->bell.insert(es, ib=new IrcBell(client, es, this));
  grid->addWidget(ib, 1, 1);

  topLayout->activate();
  readConfig();
  show();
}

OnKickPage::~OnKickPage()
{
#ifdef EDEBUG
  cout << "Destruktor OnKickPage" << endl;
#endif
}


void OnKickPage::createActionRadioBtn()
{
  QString entry;
  QButtonGroup* bg;

  btnGroup.insert("Action", bg=new QButtonGroup("Action", this));
  grid->addWidget(bg, 0, 0 );

  QVBoxLayout* vbox;
  
  vbox = new QVBoxLayout(bg, 10);
  vbox->addSpacing(bg->fontMetrics().height());

  QRadioButton* rb;
  actionText.append(entry=qstrdup("AutoJoin"));
  radioBtn.insert(entry, rb = new QRadioButton("Auto Join", bg));
  rb->setFixedHeight(rb->sizeHint().height());
  vbox->addWidget(rb);

  actionText.append(entry=qstrdup("Quiet"));
  radioBtn.insert(entry, rb = new QRadioButton("Quiet", bg));
  rb->setFixedHeight(rb->sizeHint().height());
  vbox->addWidget(rb);

  actionText.append(entry=qstrdup("Dialog"));
  radioBtn.insert(entry, rb = new QRadioButton("Dialog", bg));
  rb->setFixedHeight(rb->sizeHint().height());
  vbox->addWidget(rb);

  //bg->setFixedHeight(4*bg->fontMetrics().height());
  vbox->activate();
}

void OnKickPage::createConfigBox()
{
  QString entry;
  QGroupBox* gb;

  groupBox.insert("Config", gb=new QGroupBox("Config", this));
  grid->addWidget(gb, 0, 1);

  QVBoxLayout* vbox;
  QHBoxLayout* hbox;
  
  vbox = new QVBoxLayout(gb, 10);
  vbox->addSpacing(gb->fontMetrics().height());
  hbox = new QHBoxLayout;
  vbox->addLayout(hbox);

  QLabel* label;
  KIntegerLine* il;

  label = new QLabel("Dialog Timeout [second]", gb);
  hbox->addWidget(label,5);
  configText.append(entry="KickDlgTimeout");
  intLine.insert(entry, il = new KIntegerLine(gb, "line", KEditTypeDec));
  il->setFixedHeight(il->sizeHint().height());
  hbox->addWidget(il,1); 

  vbox->addStretch(10);
  gb->setFixedHeight(4*gb->fontMetrics().height());
  vbox->activate();
}



void OnKickPage::createPushButton()
{
  QPushButton* btn;
  btn = new QPushButton(" Apply ", this);
  connect(btn,
	  SIGNAL(clicked()),
	  this,
	  SLOT  (slotApply()));
  grid->addWidget(btn, 1, 0, AlignLeft|AlignTop);
  btn->setFixedSize(100, btn->sizeHint().height());
}

void OnKickPage::readConfig()
{
#ifdef EDEBUG
  cout << "OnKickPage::readConfig"<<endl;
#endif
  QString entry;
  QString value;

  QDictIterator<QRadioButton> it(radioBtn);
  QRadioButton* rbtn;
  for (;rbtn=it.current();++it)
     rbtn->setChecked(false);
  
  entry = "OnChannelKick";
  value = ircapp->readEntry(entry, "Quiet");
  radioBtn[value]->setChecked(true);
  ircapp->writeEntry(entry, value);
  
  // timeout
  entry = "KickDlgTimeout";
  value = ircapp->readEntry(entry, "30");
  intLine[entry]->setText(value);
  ircapp->writeEntry(entry, value);
}

void OnKickPage::slotApply()
{
#ifdef EDEBUG
  cout << "OnKickPage::slotApply:"<<endl;
#endif
  QString entry;
  QString value;
  QRadioButton* rb;

  entry = "OnChannelKick";
  for (value=actionText.first();value;value=actionText.next()){
      rb=radioBtn[value];
      if (!rb)
	 continue;
      if (rb->isChecked())
	 ircapp->writeEntry(entry, value);
  }

  // timeout
  entry = "KickDlgTimeout";
  value = intLine[entry]->text();
  ircapp->writeEntry(entry, value);

  client->bell["KickBell"]->slotApply();
}








