#include "StringToken.h"
#include "ircMsgPage.h"

#include <iostream.h>
#include <qlayout.h>
#include "ircApp.h"

IrcMsgPage::IrcMsgPage(IrcClient* Client, QWidget* parent, const char* Name):
  OutputPage(Client, parent, Name)
{
#ifdef EDEBUG
  cout << "Konstruktor IrcMsgPage" << endl;
#endif

  QVBoxLayout* vbox = new QVBoxLayout(panWidget,0);
  listBox = new IrcListBox(panWidget);
  vbox->addWidget(listBox);
  vbox->activate();

  // Connected
  connect(inpCmd, 
	  SIGNAL(signReturn(const char*)), 
	  client, 
	  SLOT  (slotInputParse(const char*)));
  connect(client,
	  SIGNAL(signWriteMsg(int, const char*, bool)),
	  SLOT  (slotWriteMsg(int, const char*, bool))
	  );
  connect(client,
	  SIGNAL(signConnect(IrcServer*)),
	  this,
	  SLOT  (slotConnect(IrcServer*))
	  );
  connect(client,
	  SIGNAL(signDisconnect(IrcServer*)),
	  this,
	  SLOT  (slotDisconnect(IrcServer*))
	  );
  createPopup();
  createToolbar();
  
#ifdef EDEBUG
  cout << "Konstruktor IrcMsgPage ... Ok" << endl;
#endif
}

IrcMsgPage::~IrcMsgPage()
{
#ifdef EDEBUG
  cout << "Destruktor IrcMsgPage" << endl;
#endif
}

void IrcMsgPage::createPopup()
{
  IrcPopup* popup;
  if (!(popup = client->popup.find("Main")))
     popup = client->popup.find("Default");

  if (popup){
     connect(ircHtml()->htmlWidget(),
	     SIGNAL(popupMenu (const char*, const QPoint&)),
	     this,
	     SLOT  (slotPopup (const char*, const QPoint&))); 

     connect(popup,
	     SIGNAL(signPopup(const char*)),
	     this,
	     SLOT  (slotPopupAction(const char*)));
  }
}

void IrcMsgPage::createToolbar()
{
  /*
  labelList["TimeLive"]->hide();
  */
}

void IrcMsgPage::slotConnect(IrcServer* is)
{
  ircapp->setOverrideCursor(waitCursor);
  QString t="";
  if ( client->state & SOCKET_SOCKS){
     QString p;
     p.setNum(client->socket.getPeerPort());
     t = " [ via proxy socks "+client->socket.getInetAddress().getHostAddress()+":"+p+" ]";
  }
  QString s="Try connect to "+is->Host()+" on port "+is->Port()+t;
  client->slotWriteMsg(TYPE_INFO|TYPE_IMG, s);
  s = "Please wait...";
  client->slotWriteMsg(TYPE_INFO|TYPE_IMG, s);
}

void IrcMsgPage::slotDisconnect(IrcServer* is)
{
  ircapp->restoreOverrideCursor();
  QString str = "Cannot established connection to port "+is->Port()+" of server "+is->Host();
  client->slotWriteMsg(TYPE_ERROR|TYPE_IMG, str);
}

void IrcMsgPage::resizeEvent(QResizeEvent* e)
{
  OutputPage::resizeEvent(e);
}

void IrcMsgPage::slotPopup(const char*, const QPoint& pos)
{
#ifdef EDEBUG
  cout << "IrcMsgPage::slotPopup()"<<endl;
#endif
  IrcPopup* popup = client->popup.find("Main");
  if (!popup)
     return;
  QPopupMenu* pu=popup->find("Main");
  if (pu){
    pu->popup(pos);
  }
}

void IrcMsgPage::slotPopupAction(const char* Action)
{  
  if (IsSelected()==true && isActiveWindow()==true)
     client->slotInputParse(Action);

  return;
}

void IrcMsgPage::slotWriteOnActive(int Type, const char* txt, bool Filter)
{
  if (IsSelected()==true && isActiveWindow())
     ircHtml()->slotWrite(Type, txt, Filter);
}

void IrcMsgPage::slotUpdateListBox(const char* s, int flag)
{
  if (flag==0){
     listBox->clear();
     panner->setSeparatorPos(99);
  }
  else if (flag==1){
     if (s!=0L && strlen(s)>0 && (s[0]=='#'||s[0]=='&'))
        listBox->inSort(s);
  }
  if (listBox->count()>0)
     panner->setSeparatorPos(80);
}

void IrcMsgPage::slotWriteMsg(int type, const char* txt, bool parse)
{
  htmlMsg->slotWrite(type, txt, parse);
  if (!IsSelected())
    emit signNewMsg();
}

#include "ircMsgPage.moc"
