#include <iostream.h>
#include <qstring.h>
#include <qclipbrd.h>
#include "ircLine.h"
#include "ircApp.h"

IrcLine::IrcLine(QWidget* parent, const char* name, int buff,  bool clean) : 
  QLineEdit(parent, name)
{
#ifdef EDEBUG
  cout << "Konstruktor IrcLine..."<<endl;
#endif
   setValidator(0L);
   autoClean = clean;
   history   = new RingList<char>(buff);
   history->add(qstrdup(""));
   fontSize  = 2;
   fontName  = "times";
   textColor = QColor(black);
   QFont f(fontName, 10+fontSize);
   setFont(f);
   connect(this, SIGNAL(returnPressed()), SLOT(slotTextReturn()));

   ircColorDlg=0L;
   inpTxt.resize(1024);
   inpTxt = "";
}

IrcLine::~IrcLine()
{
#ifdef EDEBUG
  cout << "Destruktor IrcLine" << endl;
#endif
  delete history;
  delete ircColorDlg;
}

void IrcLine::mousePressEvent(QMouseEvent* e)
{
  QLineEdit::mousePressEvent(e);
  if (e->button()==RightButton){
    QPoint pos=mapToGlobal(e->pos());
    emit signMouseRightPress(pos);
  }
  else if (e->button()==MidButton){
    QClipboard* cb = ircapp->clipboard();
    QString s =cb->text();
    if (!s.isEmpty()){
       int cpos=cursorPosition()-s.length();
       inpTxt.insert(cpos, s);
    }
  }
  setFocus();
}

void IrcLine::slotTextReturn()
{
   QString t = text();
   if (t.isNull() || t.isEmpty())
      return;
   else{
     //if (inpTxt.length()!=t.length())
     // inpTxt=t;
      history->addLast(qstrdup(inpTxt));
      emit signReturn(inpTxt);
      history->add(qstrdup(""));
      if (autoClean)
	 setText("");
   }
   inpTxt = "";
}

void IrcLine::focusOutEvent (QFocusEvent* )
{
  if(ircColorDlg!=0L && ircColorDlg->isVisible())
     ircColorDlg->hide();
}

void IrcLine::keyPressEvent(QKeyEvent* e)
{
  if (ircColorDlg!=0L)
     ircColorDlg->hide();

  QString txt = text();
  int k = e->key();

#if(QT_VERSION>=140)

  if (txt.isEmpty()){
     txt="";
     setCursorPosition(0);
  }
  int cpos=cursorPosition();

  if (e->state() & ControlButton){
     switch (k) {
     case Key_B:
       txt.insert   (cpos, 0x02);
       inpTxt.insert(cpos, 0x02);
       validateAndSet(txt, cpos+1,0,0);  
       return;
       break;
     case Key_U:
       txt.insert(cpos, 0x1F);
       inpTxt.insert(cpos, 0x1F);
       validateAndSet(txt, cpos+1,0,0);  
       return;
       break;
     case Key_I:
       txt.insert(cpos, 0x16);
       inpTxt.insert(cpos, 0x16);
       validateAndSet(txt, cpos+1,0,0);  
       return;
       break;
     case Key_K:{
       if (ircColorDlg==0L)
	  ircColorDlg = new IrcColorDlg(0L);
       else
	  ircColorDlg->setBgColor();
       QPoint point=parentWidget()->pos();
       QPoint pglob=mapToGlobal(point);
       ircColorDlg->move(pglob.x(), pglob.y()-40);
       ircColorDlg->show();
       txt.insert(cpos, 0x03);
       inpTxt.insert(cpos, 0x03);
       validateAndSet(txt, cpos+1,0,0);  
       return;
     }
       break;
     case Key_O:
       txt.insert(cpos, 0x0F);
       inpTxt.insert(cpos, 0x0F);
       validateAndSet(txt, cpos+1,0,0);  
       return;
       break;
     }
     return;
  }

  if (k==Key_Down){
      QString s=history->forward();
      setText(s);
      inpTxt = s;
      return;
  }
  else if (k==Key_Up){
      QString s= history->back();
      setText(s);
      inpTxt = s;
      return;
  }
  else if (k==Key_Left || k==Key_Right){
      QLineEdit::keyPressEvent(e);
      return;
  }

  int a=e->ascii();
  if ( a==13){
     QLineEdit::keyPressEvent(e);
     return;
  }

  if (e->key() == Key_Delete){
    if (cpos < (int)txt.length() && cpos>=0){
       txt.remove(cpos, 1);
       inpTxt.remove(cpos, 1);
       validateAndSet(txt, cpos,0,0);  
    }
    return;
  }
  if (e->key() == Key_Backspace){
     if (cpos<1)
        return;
     bool f=hasMarkedText();
     if (f){
        QString s=markedText();
	if (s==txt){
	   txt="";
	   inpTxt="";
	   validateAndSet(txt, txt.length(),0,0);  
	}
     }
     else{
        txt.remove(cpos-1, 1);
	inpTxt.remove(cpos-1, 1);
	validateAndSet(txt, cpos-1,0,0);  
     }
     return;
  }

  if (a>=32){
     txt.insert(cpos, a);
     inpTxt.insert(cpos, a);
     validateAndSet(txt, cpos+1,0,0);  
     //setText(txt);
     //setCursorPosition(cpos+1);
  }

#else

  if (e->state() & ControlButton){
     QString txt = text();
     switch (k) {
     case Key_B:
       txt += 0x02;
       setText(txt);
       return;
       break;
     case Key_U:
       txt += 0x1F;
       setText(txt);
       return;
       break;
     case Key_I:
       txt += 0x16;
       setText(txt);
       return;
       break;
     case Key_K:{
       if (ircColorDlg==0L)
	  ircColorDlg = new IrcColorDlg(0L);
       else
	  ircColorDlg->setBgColor();
       QPoint point=parentWidget()->pos();
       QPoint pglob=mapToGlobal(point);
       ircColorDlg->move(pglob.x(), pglob.y()-40);
       ircColorDlg->show();
       txt += 0x03;
       setText(txt);
       return;
     }
       break;
     case Key_O:
       txt += 0x0F;
       setText(txt);
       return;
       break;
     }
  }

  if (k==Key_Down){
      QString s=history->forward();
      setText(s);
      return;
  }
  else if (k==Key_Up){
      setText(history->back());
      return;
  }
  QLineEdit::keyPressEvent(e);

#endif

  setFocus();
}

#include "ircLine.moc"
