#include <iostream.h>
#include <stdlib.h>
#include "ircCore.h"
#include "ircCore.moc"

IrcCore::IrcCore(QObject* Parent, const char* Name, ulong CusInterval, bool Start):
  QObject(Parent, Name)
{
  idTimer     = -1;
  secWalker   =  0;
  cusInterval =  CusInterval;
  stop();
  if (Start)
     start();
}

IrcCore::~IrcCore()
{
  if (idTimer>0)
     killTimer(idTimer);
}

void IrcCore::timerEvent(QTimerEvent* e)
{
  if (idTimer==e->timerId()){
     slotTimeout();
  }
}

void IrcCore::setCusInterval(ulong itv)
{
  cusInterval = itv;
}

void IrcCore::slotTimeout()
{
  secWalker++;
  emit signSecTimeout(this);
  if (!(secWalker%60)){
     ++minutes;
     emit signMinTimeout(this);
  }
  if (!(secWalker%cusInterval))
     emit signCusTimeout(this);
  if (secWalker>= 60 && secWalker>=cusInterval)
     secWalker=0;
}

void IrcCore::start()
{
  minutes = 0;
  if (idTimer>0)
     killTimer(idTimer);
  idTimer=startTimer(1000);
}

void IrcCore::stop()
{
  minutes = 0;
  if (idTimer>0)
     killTimer(idTimer);
  idTimer=-1;
}

ulong IrcCore::getMinutes()
{
  return minutes;
}

bool IrcCore::isActive()
{
  if (idTimer<1)
     return 0;
  else
     return 1;
}



