#ifndef __DCCCHATPAGE_H__
#define __DCCCHATPAGE_H__

#include "dccChat.h"
#include "ircPopup.h"
#include "outputPage.h"

class DCCChatPage : public OutputPage
{
  Q_OBJECT
protected:
  QString     currentDCC;
  DCCClient* dccClient;
protected:
  void Init();
  void createPopup();
  void createMenu();
  void createToolbar();
  void resizeEvent(QResizeEvent*);
public slots:
  void slotChangeNick    (const char* NewNick);
  void slotDCCPopup      (const char*, const QPoint&);
  void slotDCCPopupAction(const char*);
  void slotCurrentDCC    (const char*);
  
  void slotCloseDCC();
  void slotUserInfo(const char*);
public:
  DCCPage(IrcClient* Client, QWidget* parent, const char* Name=NULL);
  ~DCCPage();
  DCCChat* getClient();
protected:
  int idTbInfo;
};

#endif 



