#ifndef __WINDOWCLIENTSETUP_H__
#define __WINDOWCLIENTSETUP_H__

#include <qlistbox.h>
#include <qframe.h>
#include <qgrpbox.h>
#include <qpushbt.h>
#include <qcombo.h>
#include <qtooltip.h>
#include <qstrlist.h>
#include <ktablistbox.h>
#include <ktabctl.h> 
#include "ircServer.h"
#include "onProxyPage.h"

class IrcClient;

class ClientSetupTab : public QFrame
{
  Q_OBJECT
protected:
  QHBoxLayout* horLayout;
  QVBoxLayout* lVerLayout;
  QVBoxLayout* rVerLayout;
protected:
  int getTextId(QComboBox* combo, const char* txt);
public:
  ClientSetupTab(IrcClient* client, QWidget* parent=0, const char* name=0 );
  ~ClientSetupTab();
public slots:
  void setCurNick   (const char* nick);
  void setCurServer (IrcServer* is);
  void addServer    (IrcServer* is);
  void addNick      (const char* s);

protected slots:
  void slotCurNick   (int idx);
  void slotCurUser   (int idx);
  void slotCurIrcname(int idx);
  void slotCurServer (int idx, int col);

protected slots:
  void slotAddServer();
  void slotDelServer();
  void slotEditServer();
  void slotAddNick();
  void slotDelNick();
  void slotAddUser();
  void slotDelUser();
  void slotAddIrcname();
  void slotDelIrcname();
public slots:
  void slotApply();
protected:
  void setConnect();
private:
  QDict<QPushButton> pb;
  QDict<QComboBox>   cb;
  KTabListBox*       serverBox;
  IrcClient* client;
  QStrList*  listServer;
};

class IrcSetup : public QDialog
{
  Q_OBJECT
protected:
   KTabCtl*        tabCtl;
   ClientSetupTab* clientSetupTab;
   OnProxyPage*    proxyTab;
   SocksPage*      listProxyTab;
public:
  IrcSetup (IrcClient* client, QWidget* parent=0L, const char* name=0L);
  ~IrcSetup();
  SocksPage* proxyList(){
     return listProxyTab;
  }
public slots:
   void slotOk();
   void slotCancel();
   virtual void show(){
     QPoint p=pos();
     move(p);
     if (isVisible())
        raise();
     else
        QDialog::show();
   }
private:
   IrcClient* client;
};

#endif












