/***************************************************************************
                          kcmkeafnode4.cpp  -  description                              
                             -------------------                                         
    begin                : Tue Aug 10 1999                                           
    copyright            : (C) 1999 by Guenter Schwann                         
    email                : vogel@ibk.dyn.priv.at                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include <qwidget.h>
#include <qlayout.h>
#include <qcheckbox.h>
#include <qstring.h>
#include <qlineedit.h>
#include <qlabel.h>

#include <kapp.h>
#include <kconfig.h>

#include "kcmkeafnode4.h"


KDEkeafConfig4::KDEkeafConfig4(Parser *p, QWidget *parent, const char *name)
    : KConfigWidget(parent, name)
{
  pars=p;
    QVBoxLayout *top_lay = new QVBoxLayout(this, 10);

    top_lay->addStretch(1);

    QHBoxLayout *h1_lay = new QHBoxLayout();
    top_lay->addLayout(h1_lay);

    h1_lay->addStretch(1);
    QLabel *lbl = new QLabel(i18n("Max fetch"), this);
    lbl->setFixedSize(lbl->sizeHint());
    h1_lay->addWidget(lbl);

    mfetch = new KIntegerLine(this);
    mfetch->setValue(99999);
    mfetch->setFixedSize(80,25);
    mfetch->clear();
    h1_lay->addWidget(mfetch);
    h1_lay->addStretch(5);

    h1_lay->addStretch(1);
    QLabel *lbl1 = new QLabel(i18n("initial fetch"), this);
    lbl1->setFixedSize(lbl1->sizeHint());
    h1_lay->addWidget(lbl1);
    h1_lay->addStretch(1);

    ifetch = new KIntegerLine(this);
    ifetch->setValue(99999);
    ifetch->setFixedSize(80,25);
    ifetch->clear();
    h1_lay->addWidget(ifetch);
    h1_lay->addStretch(5);


    QHBoxLayout *h2_lay = new QHBoxLayout();
    top_lay->addLayout(h2_lay);

    h2_lay->addStretch(1);
    delayb = new QCheckBox(this);
    delayb->setFixedSize(delayb->sizeHint());
    h2_lay->addWidget(delayb);

    QLabel *lbl2 = new QLabel(i18n("delay body"), this);
    lbl2->setFixedSize(lbl2->sizeHint());
    h2_lay->addWidget(lbl2);

    h2_lay->addStretch(5);

    QHBoxLayout *h3_lay = new QHBoxLayout();
    top_lay->addLayout(h3_lay);

    h3_lay->addStretch(1);
    QLabel *lbl3 = new QLabel(i18n("Max cross postings"), this);
    lbl3->setFixedSize(lbl3->sizeHint());
    h3_lay->addWidget(lbl3);

    maxcross = new KIntegerLine(this);
    maxcross->setValue(9999);
    maxcross->setFixedSize(80,25);
    maxcross->clear();
    h3_lay->addWidget(maxcross);
    h3_lay->addStretch(5);

    QHBoxLayout *h4_lay = new QHBoxLayout();
    top_lay->addLayout(h4_lay);

    h4_lay->addStretch(1);
    QLabel *lbl4 = new QLabel(i18n("Max age"), this);
    lbl4->setFixedSize(lbl4->sizeHint());
    h4_lay->addWidget(lbl4);

    mage = new KIntegerLine(this);
    mage->setValue(999);
    mage->setFixedSize(80,25);
    mage->clear();
    h4_lay->addWidget(mage);
    h4_lay->addStretch(5);

    QHBoxLayout *h5_lay = new QHBoxLayout();
    top_lay->addLayout(h5_lay);

    h5_lay->addStretch(1);
    QLabel *lbl5 = new QLabel(i18n("Max lines"), this);
    lbl5->setFixedSize(lbl5->sizeHint());
    h5_lay->addWidget(lbl5);

    malines = new KIntegerLine(this);
    malines->setValue(9999);
    malines->setFixedSize(80,25);
    malines->clear();
    h5_lay->addWidget(malines);
    h5_lay->addStretch(1);

    h5_lay->addStretch(1);
    QLabel *lbl51 = new QLabel(i18n("Min lines"), this);
    lbl51->setFixedSize(lbl51->sizeHint());
    h5_lay->addWidget(lbl51);

    milines = new KIntegerLine(this);
    milines->setValue(999);
    milines->setFixedSize(80,25);
    milines->clear();
    h5_lay->addWidget(milines);
    h5_lay->addStretch(3);

    QHBoxLayout *h6_lay = new QHBoxLayout();
    top_lay->addLayout(h6_lay);

    h6_lay->addStretch(1);
    QLabel *lbl6 = new QLabel(i18n("Max bytes"), this);
    lbl6->setFixedSize(lbl6->sizeHint());
    h6_lay->addWidget(lbl6);

    mbytes = new KIntegerLine(this);
    mbytes->setValue(999);
    mbytes->setFixedSize(80,25);
    mbytes->clear();
    h6_lay->addWidget(mbytes);
    h6_lay->addStretch(5);

    QHBoxLayout *h7_lay = new QHBoxLayout();
    top_lay->addLayout(h7_lay);

    h7_lay->addStretch(1);
    QLabel *lbl7 = new QLabel(i18n("Timeout short"), this);
    lbl7->setFixedSize(lbl7->sizeHint());
    h7_lay->addWidget(lbl7);

    timeoutsh = new KIntegerLine(this);
    timeoutsh->setValue(999);
    timeoutsh->setFixedSize(80,25);
    timeoutsh->clear();
    h7_lay->addWidget(timeoutsh);
    h7_lay->addStretch(1);

    h7_lay->addStretch(1);
    QLabel *lbl71 = new QLabel(i18n("Timeout long"), this);
    lbl71->setFixedSize(lbl71->sizeHint());
    h7_lay->addWidget(lbl71);
    h1_lay->addStretch(1);

    timeoutlo = new KIntegerLine(this);
    timeoutlo->setValue(999);
    timeoutlo->setFixedSize(80,25);
    timeoutlo->clear();
    h7_lay->addWidget(timeoutlo);
    h7_lay->addStretch(3);

    QHBoxLayout *h8_lay = new QHBoxLayout();
    top_lay->addLayout(h8_lay);

    h8_lay->addStretch(1);
    QLabel *lbl8 = new QLabel(i18n("Timeout active file"), this);
    lbl8->setFixedSize(lbl8->sizeHint());
    h8_lay->addWidget(lbl8);

    timeoutact = new KIntegerLine(this);
    timeoutact->setValue(999);
    timeoutact->setFixedSize(80,25);
    timeoutact->clear();
    h8_lay->addWidget(timeoutact);
    h8_lay->addStretch(5);

    QHBoxLayout *h9_lay = new QHBoxLayout();
    top_lay->addLayout(h9_lay);

    h9_lay->addStretch(1);
    alllinks = new QCheckBox(this);
    alllinks->setFixedSize(alllinks->sizeHint());
    h9_lay->addWidget(alllinks);

    QLabel *lbl9 = new QLabel(i18n("Create all links"), this);
    lbl9->setFixedSize(lbl9->sizeHint());
    h9_lay->addWidget(lbl9);
    h9_lay->addStretch(5);

    QHBoxLayout *h10_lay = new QHBoxLayout();
    top_lay->addLayout(h10_lay);

    h10_lay->addStretch(1);
    QLabel *lbl10 = new QLabel(i18n("Hostname"), this);
    lbl10->setFixedSize(lbl10->sizeHint());
    h10_lay->addWidget(lbl10);

    honame = new QLineEdit(this);
    honame->setText("");
    honame->setFixedSize(200,25);
    honame->clear();
    h10_lay->addWidget(honame);
    h10_lay->addStretch(2);


    top_lay->addStretch(1);

    loadSettings();

}


KDEkeafConfig4::~KDEkeafConfig4()
{
}

void KDEkeafConfig4::loadSettings()
{

 pars->SearchCFile();
 conf_file=pars->CFileName();

 maxfetch=pars->MaxFetch();
 initfetch=pars->InitialFetch();
 if (pars->DelayBody()!=0) delaybody=true;
 maxcrosspost=pars->MaxCrossPost();
 maxage=pars->MaxAge();
 maxlines=pars->MaxLines();
 minlines=pars->MinLines();
 maxbytes=pars->MaxBytes();
 timeoutshort=pars->TimeoutShort();
 timeoutlong=pars->TimeoutLong();
 timeoutactive=pars->TimeoutActive();
 if (pars->CreateLinks()!=0) createalllinks=true;
 hname=pars->Hostname();

 updateSettings();
}


void KDEkeafConfig4::applySettings()
{
 FILE *f;
 QString s;
 QStrList qsl;

 qsl=pars->UTags();
 fetchData();
 conf_file=pars->CFileName();
 if ((f=fopen(conf_file.data(),"a"))!=0)
 {
  fprintf(f,"\n## Never fetch more than this many articles from one group in one run.\n");
  fprintf(f,"## Be careful with this; setting it much below 1000 is probably a bad\n");
  fprintf(f,"## idea.\n");
  if (maxfetch==0) s="#maxfetch = 1000\n";
  else s="maxfetch = "+s.setNum(maxfetch)+"\n";
  fprintf(f,s.data());

  fprintf(f,"\n## Fetch only a few articles when we subscribe a new newsgroup. The\n");
  fprintf(f,"## default is to fetch all articles.\n");

  if (initfetch==0) s="#initfetch = 100\n";
  else s="initfetch = "+s.setNum(initfetch)+"\n";
  fprintf(f,s.data());

  fprintf(f,"\n## If you want to use leafnode like an offline newsreader (e.g. Forte\n");
  fprintf(f,"## Agent) you can download headers and bodies separately if you set\n");
  fprintf(f,"## delaybody to 1. In this case, fetch will only download the headers\n");
  fprintf(f,"## and only when you select an article, it will download the body.\n");
  fprintf(f,"## This can save a huge amount of bandwith if only few articles are really\n");
  fprintf(f,"## read from groups with lots of postings.\n");
  fprintf(f,"## This feature works not very well with Netscape, though (which is not\n");
  fprintf(f,"## a fault of Leafnode).\n");

  if (delaybody==false) s="#delaybody = 0\n";
  else s="delaybody = 1\n";
  fprintf(f,s.data());

  fprintf(f,"\n## To avoid spam, you can select the maximum number of crosspostings\n");
  fprintf(f,"## that are allowed in incoming postings. Setting this below 5 is\n");
  fprintf(f,"## probably a bad idea. The default is unlimited crossposting.\n");
  if (maxcrosspost==0) s="#maxcrosspost = 100\n";
  else s="maxcrosspost = "+s.setNum(maxcrosspost)+"\n";
  fprintf(f,s.data());

  fprintf(f,"\n## If you suffer from repeatedly receiving old postings (this happens\n");
  fprintf(f,"## sometimes when an upstream server goes into hiccup mode) you can\n");
  fprintf(f,"## refuse to receive them with the parameter \"maxage\" which tells the\n");
  fprintf(f,"## maximum allowed age of an article in days. The default maxage is 10\n");
  fprintf(f,"## days.\n");
  if (maxage==0) s="#maxage = 100\n";
  else s="maxage = "+s.setNum(maxage)+"\n";
  fprintf(f,s.data());

  fprintf(f,"\n## maxlines will make fetch reject postings that are longer than a certain\n");
  fprintf(f,"## amount of lines.\n");
  if (maxlines==0) s="#maxlines = 1000\n";
  else s="maxlines = "+s.setNum(maxlines)+"\n";
  fprintf(f,s.data());

  fprintf(f,"\n## minlines will make fetch reject postings that are shorter than a certain\n");
  fprintf(f,"## amount of lines.\n");
  if (minlines==0) s="#minlines = 2\n";
  else s="minlines = "+s.setNum(minlines)+"\n";
  fprintf(f,s.data());

  fprintf(f,"\n## maxbytes will make fetch reject postings that are larger\n");
  if (maxbytes==0) s="#maxbytes = 1000\n";
  else s="maxbytes = "+s.setNum(maxbytes)+"\n";
  fprintf(f,s.data());

  fprintf(f,"\n## timeout_short determines how many days fetch gets a newsgroup which\n");
  fprintf(f,"## has been accidentally opened. The default is two days.\n");
  if (timeoutshort==0) s="#timeout_short = 2\n";
  else s="timeout_short = "+s.setNum(timeoutshort)+"\n";
  fprintf(f,s.data());

  fprintf(f,"\n## timeout_long determines how many days fetch will wait before not getting\n");
  fprintf(f,"## an unread newsgroup any more. The default is seven days.\n");
  if (timeoutlong==0) s="#timeout_long = 7\n";
  else s="timeout_long = "+s.setNum(timeoutlong)+"\n";
  fprintf(f,s.data());

  fprintf(f,"\n## timeout_active determines how many days fetch will wait before re-reading\n");
  fprintf(f,"## the whole active file. The default is 90 days.\n");
  if (timeoutactive==0) s="#timeout_active = 365\n";
  else s="timeout_active = "+s.setNum(timeoutactive)+"\n";
  fprintf(f,s.data());

  fprintf(f,"\n## If you want to have your newsreader score/kill on Xref: lines, you might\n");
  fprintf(f,"## want to uncomment this.\n");
  if (createalllinks==false) s="#create_all_links = 1\n";
  else s="create_all_links = 1\n";
  fprintf(f,s.data());

  fprintf(f,"\n##Use another hostname\n");
  if (hname.isEmpty()) s="#hostname =\n";
  else s="hostname = "+hname+"\n";
  fprintf(f,s.data());

  fprintf(f,"\n##Unknown tags keafnode found before\n");
  qsl.first();
  while (qsl.current()!=0)
  {
   s=qsl.current();
   s=s+"\n";
   fprintf(f,s.data());
   qsl.next();
  }

  fprintf(f,"\n");
  fclose(f);
 }
 else printf("Error opening file!");
}

void KDEkeafConfig4::defaultSettings()
{
/* pars->defaults(0);
 maxfetch=pars->MaxFetch();
 initfetch=pars->InitialFetch();
 if (pars->DelayBody()!=0) delaybody=true;
 maxcrosspost=pars->MaxCrossPost();
 maxage=pars->MaxAge();
 maxlines=pars->MaxLines();
 minlines=pars->MinLines();
 maxbytes=pars->MaxBytes();
 timeoutshort=pars->TimeoutShort();
 timeoutlong=pars->TimeoutLong();
 timeoutactive=pars->TimeoutActive();
 if (pars->CreateLinks()!=0) createalllinks=true;

 updateSettings();*/
}

void KDEkeafConfig4::updateSettings()
{
 mfetch->setValue(maxfetch);
 ifetch->setValue(initfetch);
 delayb->setChecked(delaybody);
 maxcross->setValue(maxcrosspost);
 mage->setValue(maxage);
 malines->setValue(maxlines);
 milines->setValue(minlines);
 mbytes->setValue(maxbytes);
 timeoutsh->setValue(timeoutshort);
 timeoutlo->setValue(timeoutlong);
 timeoutact->setValue(timeoutactive);
 alllinks->setChecked(createalllinks);
 honame->setText(hname);
}

void KDEkeafConfig4::fetchData()
{
 maxfetch=mfetch->value();
 initfetch=ifetch->value();
 delaybody=delayb->isChecked();
 maxcrosspost=maxcross->value();
 maxage=mage->value();
 maxlines=malines->value();
 minlines=milines->value();
 maxbytes=mbytes->value();
 timeoutlong=timeoutlo->value();
 timeoutshort=timeoutsh->value();
 timeoutactive=timeoutact->value();
 createalllinks=alllinks->isChecked();
 hname=honame->text();
}

