/************************************************************
        Copyright (c) 1997 Michael Glauche
        Copyright (c) 1998 Karl Backstrm

        This code is under GPL - see COPYING.
************************************************************/


#ifndef _BIND_
#define _BIND_

#include <signal.h>
#include <unistd.h>
#include <time.h>

#include "kcontrol.h"

#include <qwidget.h>
#include <qframe.h>
#include <qlabel.h>
#include <qtabdlg.h>
#include <qpushbt.h>
#include <qtimer.h>
#include <qlist.h>
#include <qlistbox.h>
#include <qlined.h>
#include <qstrlist.h>
#include <qchkbox.h>
#include <qgroupbox.h>
#include <ktabctl.h>
#include <qregexp.h>
#include <qlayout.h>
#include <qfile.h>
#include <qtstream.h>
#include <qtextstream.h>
#include <qfont.h>

#include <kapp.h>
#include <ktopwidget.h>
#include <ktablistbox.h>
#include <kconfig.h>
#include <klocale.h>
#include <kpanner.h>
#include <kmsgbox.h>

#include "primarydomain.h" 
#include "record.h"

#define no_recursion 	1
#define no_fetch_glue	2
#define query_log	4
#define forward_only	8
#define fake_iquery	16

#define TYPE_A     1
#define TYPE_NS    2
#define TYPE_CNAME 5
#define TYPE_SOA   6
#define TYPE_MB    7
#define TYPE_MG    8
#define TYPE_MR    9
#define TYPE_WKS   11
#define TYPE_PTR   12
#define TYPE_HINFO 13
#define TYPE_MINFO 14
#define TYPE_MX    15
#define TYPE_TXT   16
#define TYPE_RP    17
#define TYPE_AFSDB 18
#define TYPE_X25   19
#define TYPE_ISDN  20
#define TYPE_RT    21

/* I hope thats all ... */

struct secondaryDomain {
  QString domain;
  QString file;
  QStrList *ip;
  int count;
  int checknames;            // default || warn || fail || ignore
  bool notify;                // Yes_no
  int type;                   // none || in || hs || hesiod || chaos
  int maxtransfertimein;   // 
  QStrList *alsonotify;
};


class KBindWidget : public KConfigWidget
{
  Q_OBJECT;

public:

  KBindWidget(QWidget *parent, const char *name);
  ~KBindWidget();
  void readConfig() {};
  void loadSettings() {};
  void applySettings();
  bool bind81config_read, bind81config_write, status_check, auto_reverse_lookup;
  
private:
  QLabel *testlabel,*pl1,*pl2,*sl1,*sl2,*ml1,*ml2,*ml3, *ml4, *ml5, *ml6, *ml7, *tl, *bind_81;
  QWidget *primary, *second, *misc, *misc2, *forward,*xfer;
  QWidget *bogus,*simplestats,*detailstats;  
  QListBox *plist, *slist,*flist,*xlist,*blist,*simplestatlist;
  QLineEdit *diredit, *cacheedit, *xferedit, *dumpedit, *memstatisticsedit, *pidedit, *statisticsedit;
  KTabListBox *statlist;
  QGroupBox *option_box, *option_box2;
  KConfig *kc;

  QCheckBox *fo_check, *nor_check, *nofg_check, *nan_check,
            *ql_check, *fi_check, *non_check, *mc_check, *hs_check, *doe_check;

  QString *directory, *cache, *namedxfer, *dump, *memstatistics, *pid, *statistics;
  int options;

  QStrList *forwarders, *xfrnets, *bogusns;
  
  QPushButton *delp, *newp, *news, *dels, *newf;
  QPushButton *delf, *newx, *delx, *newb, *delb, *setup;

  QPushButton *startButton, *stopButton, *restartButton,
    *statusButton, *dumpButton;

  //Beginning check-names section.
  QGroupBox *checkNamesGroupBox;
  QLabel *checkNamePrimaryLabel;
  QComboBox *checkNamePrimaryComboBox;  
  QLabel *checkNameSecondaryLabel;
  QComboBox *checkNameSecondaryComboBox;
  QLabel *checkNameResponseLabel;
  QComboBox *checkNameResponseComboBox;

  //Beginning limits section.
  QGroupBox *limitsGroupBox;
  QGroupBox *limits2GroupBox;
  QLabel *limitDataSizeLabel;
  QLineEdit *limitDataSizeEdit;
  QLabel *limitMaxFileHandlesLabel;
  QLineEdit *limitMaxFileHandlesEdit;
  QLabel *limitTransfersInLabel;
  QLineEdit *limitTransfersInEdit;
  QLabel *limitTransfersOutLabel;
  QLineEdit *limitTransfersOutEdit;
  QLabel *limitTransfersPerNsLabel;
  QLineEdit *limitTransfersPerNsEdit;
  QLabel *limitMaxTransferTimeInLabel;
  QLineEdit *limitMaxTransferTimeInEdit;
  QLabel *limitTransferFormatLabel;
  QComboBox  *limitTransferFormatComboBox;
  QLabel *limitCoreSizeLabel;
  QLineEdit *limitCoreSizeEdit;
  QLabel *limitStackSizeLabel;
  QLineEdit *limitStackSizeEdit;
  
  //Beginning interval section.
  QGroupBox *intervalGroupBox;
  QLabel *intervalCleaningLabel;
  QLineEdit *intervalCleaningEdit;
  QLabel *intervalInterfaceLabel;
  QLineEdit *intervalInterfaceEdit;
  QLabel *intervalStatisticsLabel;
  QLineEdit *intervalStatisticsEdit;

  bool named_81_style;
  
  QList<PrimaryDomain> *primaryList;
  QList<secondaryDomain> *secondaryList;

  void init();
  void parseboot();
  void parselog();
  void readStat();
  void displaySettings();
  int  readSOA(PrimaryDomain *pl,QString path);
  bool isIP(QString ip);
  int  ptodel, stodel, ftodel, xtodel, btodel;
  bool yes_no(const char *);
public slots:

private slots:
  void primaryClick(const char * a);
  void secondaryClick(const char * a);
  void pnewclicked();
  void pdelclicked();
  void plistsel(int);
  void snewclicked();
  void sdelclicked();
  void slistsel(int);
  void fnewclicked();
  void fdelclicked();
  void flistsel(int);
  void xnewclicked();
  void xdelclicked();
  void xlistsel(int);
  void bnewclicked();
  void bdelclicked();
  void blistsel(int);
  void setupclicked();

  void StartClicked();
  void StopClicked();
  void RestartClicked();
  void StatusClicked();
  void DumpClicked();

};


#endif
