/* $Id: docking.cpp,v 1.3 1999/02/19 15:41:32 koss Exp $
   $Log: docking.cpp,v $
   Revision 1.3  1999/02/19 15:41:32  koss
   Reenbled pasting with middle button in the dock widget ( now it also
   beeps for notification )

   Revision 1.4  1999/02/07 17:13:59  matt
   modified docking policy

   Revision 1.1  1998/03/02 14:28:43  matt
   Added animation


   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   */

#include <qpainter.h>

#include <kapp.h>
#include <kwm.h>

#include "MotifDNDHandler.h"
#include "kmainwidget.h"
#include "docking.h"

#define ICONWIDTH 24
#define ICONHEIGHT 24

DockWidget::DockWidget() : QWidget(0)
{
  docked = false;

  QString path = kapp->kde_datadir() + "/caitoo/pics/";

  QPixmap *tmppix = new QPixmap();
  tmppix->load( path + "dock_hand1.xpm" );
  handpix1 = new QPixmap( ICONWIDTH, ICONHEIGHT );
  handpix1->fill(backgroundColor());
  bitBlt( handpix1, 0, 0, tmppix );
  delete tmppix;

  tmppix = new QPixmap();
  tmppix->load( path + "dock_hand2.xpm" );
  handpix2 = new QPixmap( ICONWIDTH, ICONHEIGHT );
  handpix2->fill(backgroundColor());
  bitBlt( handpix2, 0, 0, tmppix );
  delete tmppix;

  tmppix = new QPixmap();
  tmppix->load( path + "dock_hand3.xpm" );
  handpix3 = new QPixmap( ICONWIDTH, ICONHEIGHT );
  handpix3->fill(backgroundColor());
  bitBlt( handpix3, 0, 0, tmppix );
  delete tmppix;

  setBackgroundPixmap( *handpix1 );

  for ( int i = 0; i < 3; i++ )
    size[i] = 0;

  // popup menu for right mouse button
  popupMenu = new QPopupMenu();
  popupMenu->insertItem(i18n("Restore"), this, SLOT( slotRestore() ) );
  popupMenu->insertItem(i18n("Preferences"), kmain, SLOT( slotPreferences() ) );
  popupMenu->insertSeparator();
  popupMenu->insertItem(i18n("Quit"), kmain, SLOT(quit()));

  KDNDDropZone *myDropZone = new KDNDDropZone(this, DndURL);
  connect( myDropZone, SIGNAL( dropAction( KDNDDropZone *) ), 
	   this, SLOT( slotDropEvent( KDNDDropZone *) ) );
}


DockWidget::~DockWidget() {
  delete handpix1;
  delete handpix2;
  delete handpix3;
  delete popupMenu;
}


void DockWidget::setAnim( int i1, int i2, int i3, bool online ) {

  size[0] = i1;
  size[1] = i2;
  size[2] = i3;

  if ( isVisible() ) {

    if ( !online )
      setBackgroundPixmap( *handpix3 );
    else if ( size[0] == 0 && size[1] == 0 && size[2] == 0 )
      setBackgroundPixmap( *handpix1 );
    else {
      QPixmap pm( *handpix2 );
      QPainter p;
      p.begin( &pm );

      p.setPen( white );
      for ( int i = 0; i < 3; i++ ) {
	if ( size[i] != 0 ) {
	  int pixels = (int)( ICONWIDTH * (float)size[i] / 100.0 );
	  p.fillRect( 1, i*8, pixels, 7, blue );
	}
      }

      p.end();
      setBackgroundPixmap( pm );
    }
  }
}


void DockWidget::slotDropEvent( KDNDDropZone *zone ){
  kmain->slotDropEvent ( zone );
}


void DockWidget::dock() {

  if (!docked) {

    // that's all the space there is
    this->setFixedSize(ICONWIDTH, ICONHEIGHT);

    // prepare panel to accept this widget
    KWM::setDockWindow (this->winId());

    // finally dock the widget
    this->show();

    // Enable dropping
    MotifDNDHandler::setAcceptMotifDrops( this );
    setAcceptDrops( true );

    setBackgroundPixmap( *handpix1 );//this is just a hack for Qt 1.42, for Qt 2.0 it is not needed

    docked = true;
  } 
}


void DockWidget::undock() {

  if (docked) {

    // the widget's window has to be destroyed in order 
    // to undock from the panel. Simply using hide() is
    // not enough (seems to be necessary though).

    this->hide();
    this->destroy(true, true);
    // recreate window for further dockings
    this->create(0, true, false);

    docked = false;
  }
}


void DockWidget::mousePressEvent(QMouseEvent *e) {

  // open/close caitoo window on left mouse button 
  if ( e->button() == LeftButton )
    kmain->slotNormalWindow();
  else if ( e->button() == RightButton )  // open popup menu on right mouse button
    {
      popupMenu->move(-1000,-1000);
      popupMenu->show();
      popupMenu->hide();
      QRect g = KWM::geometry( this->winId() );
      if ( g.x() > QApplication::desktop()->width()/2 &&
	   g.y()+popupMenu->height() > QApplication::desktop()->height() )
	popupMenu->popup(QPoint( g.x(), g.y() - popupMenu->height()));
      else
	popupMenu->popup(QPoint( g.x() + g.width(), g.y() + g.height()));

      popupMenu->exec();
    }
  else if ( e->button() == MidButton )
    kmain->pasteTransfer();

}


void DockWidget::slotRestore() {

  if ( kmain->getStyle9x() )
    kmain->slotNormalWindow();
  else
    kmain->slotDock();
}
