/* $Id: dlgSystem.h,v 1.1.1.1 1999/02/10 18:16:34 koss Exp $
   $Log: dlgSystem.h,v $
   Revision 1.1.1.1  1999/02/10 18:16:34  koss
   Imported sources

   Revision 1.1  1999/02/07 17:11:29  matt
   source entered


   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef _DLGSYSTEM_H
#define _DLGSYSTEM_H

#include <qwidget.h>
#include <qlabel.h>
#include <qgroupbox.h> 
#include <qcombobox.h>
#include <qbuttongroup.h>
#include <qradiobutton.h>
#include <qcheckbox.h>
#include <qpushbutton.h>

class DlgSystem : public QWidget
{
  Q_OBJECT
public:
  DlgSystem(QWidget *parent=0, const char *name=0, WFlags f=0);
  ~DlgSystem();

  void setData(QStrList *strList);
  QStrList getData() const;
  void setFontData(QFont font);
  QFont getFontData() const;
     
private:

  // sound settings
  QCheckBox *cb_useSound;

  QComboBox *cmb_sounds;
  QPushButton *pb_changesound;
  QPushButton *pb_testsound;

  QString soundAdded;
  QString soundStarted;
  QString soundFinished;
  QString soundFinishedAll;

  // animation settings
  QCheckBox *cb_useAnimation;

  // window style settings
  QButtonGroup *bg_window;
  QRadioButton *rb_normal;
  QRadioButton *rb_docked;
  QRadioButton *rb_droptarget;
  QCheckBox *cb_style9x;

  // font settings
  QGroupBox *gb_font;
  QLabel *lb_font;
  QPushButton *pb_browse;

private slots:
  void changeFont();

  void setupSound();
  void testSound();
};

#endif // _DLGSYSTEM_H
