/* $Id: dlgLimits.cpp,v 1.2 1999/02/19 15:40:30 koss Exp $
   $Log: dlgLimits.cpp,v $
   Revision 1.2  1999/02/19 15:40:30  koss
   disabled unsupported features

   Revision 1.1.1.1  1999/02/10 18:16:34  koss
   Imported sources

   Revision 1.1  1999/02/07 17:11:28  matt
   source entered


   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include <qlayout.h>

#include <kapp.h>

#include "dlgLimits.h"

extern QString getStringFromInt( int x );
extern int getIntFromString( QString s );

DlgLimits::DlgLimits(QWidget *parent, const char *name, WFlags f)
  : QWidget(parent, name, f)
{

  QVBoxLayout *topLayout = new QVBoxLayout( this, 10, 5 );
  topLayout->addSpacing( 5 );

  gb_limits = new QGroupBox(this, "gb_limits");
  gb_limits->setTitle(i18n("Limits Options"));
  topLayout->addWidget( gb_limits, 5 );

  QGridLayout *gridLayout = new QGridLayout( gb_limits, 3, 5, 5 );

  gridLayout->addRowSpacing(0,5);
  gridLayout->addRowSpacing(2,5);

  gridLayout->addColSpacing(0,5);
  gridLayout->addColSpacing(4,5);

  gridLayout->setRowStretch(0,5);
  gridLayout->setRowStretch(1,5);
  gridLayout->setRowStretch(2,2);

  gridLayout->setColStretch(0,2);
  gridLayout->setColStretch(1,5);
  gridLayout->setColStretch(2,5);
  gridLayout->setColStretch(3,5);
  gridLayout->setColStretch(4,2);

  // opened connection
  lb_maxnum = new QLabel(i18n("Maximum number of opened connections :"), gb_limits);
  gridLayout->addMultiCellWidget( lb_maxnum, 1, 1, 1, 2 );

  le_maxnum = new KIntegerLine(gb_limits);
  le_maxnum->setFixedHeight( le_maxnum->sizeHint().height() );
  gridLayout->addWidget( le_maxnum, 1, 3 );

  //
  gridLayout->activate();

  topLayout->addStretch( 15 );
  topLayout->activate();
}


DlgLimits::~DlgLimits()
{
}


void DlgLimits::setData(QStrList *strList)
{
  le_maxnum->setValue( getIntFromString( strList->first() ) );
}

static QStrList strList(true);

QStrList DlgLimits::getData() const
{
  strList.clear();
  
  strList.append( getStringFromInt( le_maxnum->value() ) );

  return strList;
}

