/*
    This file is part of ktvision, a front end to frame grabber cards 
	for the KDE-Project
    
    Copyright (C) 1998 Oliver Burtchen <oliver.burtchen@rz.hu-berlin.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include "Settings.h"

#define Inherited SettingsData

Settings::Settings
(
	QWidget* parent,
	const char* name
)
	:
	Inherited( parent, name )
{
	
	chanLabelP->setText(i18n("Channel"));
	fineLabelP->setText(i18n("Fine-Tune"));
	inputLabelP->setText(i18n("Source"));
	formatLabelP->setText(i18n("Format"));
	addButP->setText(i18n("New"));
	delButP->setText(i18n("Delete"));
	resetP->setText(i18n("Reset"));
	
	
	delBut = delButP;
	addBut = addButP;
	chanEdit = chanEditP;
	memLcd = memLcdP;
	chanSlider = chanSliderP;
	fineSlider = fineSliderP;
	input = inputP;
	format = formatP;
	reset = resetP;

	connect(chanSliderP, SIGNAL(valueChanged(int)), 
			chanLcdP, SLOT(display(int)));
	connect(fineSliderP, SIGNAL(valueChanged(int)),
			fineLcdP, SLOT(display(int)));
}

Settings::~Settings()
{
}

#include "Settings.moc"
#include "SettingsData.moc"
