// -*- c++ -*-
// **************************************************************
// $Source: /home/proj/mmm/cvsroot/mmm/modules/MLevelAnalyser.cc,v $
// $Revision: 1.1 $
// $Date: 1999/05/13 08:02:16 $
// $State: Exp $
// **************************************************************

#define MODULE_NAME "level-analyser"

#include "ModuleMacros.h"
#include "PNSigStoredNumber.h"

BEGIN_MODULE_DEFINITION(LevelAnalyser);
    Slot *sslot_input;
    Number level;
END_MODULE_DEFINITION(LevelAnalyser);

class SSigLevelAnalyserOutput : public Signal
{
    Number *level;
public:
    SSigLevelAnalyserOutput(MLevelAnalyser *m, Number *level) 
	: Signal(SOUND_TYPE, "output", "Same as input", m), level(level) {};
    PreparedSignal *prepareSignal(Metainfo *, const Parameterset *);
};

class NSigLevelAnalyserLevel : public Signal
{
    Number *level;
public:
    NSigLevelAnalyserLevel(Module *m, Number *level)
	: Signal(NUMBER_TYPE, "level", "Averaged sound level", m), level(level) {};
    PreparedSignal *prepareSignal(Metainfo *, const Parameterset *)
	{ return new PNSigStoredNumber(level); };
};

class PSSigLevelAnalyserOutput : public PreparedSoundSignal
{
    PreparedSoundSignal *pssig_input;
    Number *level;
public:
    PSSigLevelAnalyserOutput(PreparedSoundSignal *pssig_input, Number *level)
	: pssig_input(pssig_input), level(level) {};
    ~PSSigLevelAnalyserOutput() { delete pssig_input; };
    SoundPortion getSoundPortion(long start_time, long number_of_samples);
};


// ---------------------------------------------------------------------------
//                             Implementation
// ---------------------------------------------------------------------------

MLevelAnalyser::MLevelAnalyser(string)
    : level(0)
{
    addConnector(sslot_input = new Slot(SOUND_TYPE, "input", "Input sound signal", this, 5));

    addConnector(new NSigLevelAnalyserLevel(this, &level));
    addConnector(new SSigLevelAnalyserOutput(this, &level));
}


PreparedSignal *SSigLevelAnalyserOutput::prepareSignal(Metainfo *mi,
							const Parameterset *parset)
{
    // No parameters nor metainfo is involved
    PSSigLevelAnalyserOutput *pps = new PSSigLevelAnalyserOutput(
	getPreparedSoundSignal(this,  
			       ((MLevelAnalyser *)getModule())->sslot_input, 
			       mi, parset),
	level);
    return pps;
}

SoundPortion PSSigLevelAnalyserOutput::getSoundPortion(long start_time, 
							long number_of_samples)
{
    SoundPortion sp = pssig_input->getSoundPortion(start_time, number_of_samples);
    
    // Now average level and store result in *level;
    const Number *samples = sp.getSamples();
    Number l = 0;
    int d=0;
    for (long s=0; s<number_of_samples; s+=d)
    {
	l += samples[s];
	d++;
    }
    *level = l / d;
    return sp;
}
