// -*- c++ -*-
// **************************************************************
// $Source: /home/proj/mmm/cvsroot/mmm/editor/EditorState.cc,v $
// $Revision: 1.1 $
// $Date: 1999/05/13 08:14:35 $
// $State: Exp $
// **************************************************************

#include <qkeycode.h>

#include "EditorState.h"
#include "ESNothing.h"

EditorState *EditorState::handleEvent(const QEvent *e)
{
    switch (e->type()) {
    case Event_MouseButtonPress:   return mousePressEvent((QMouseEvent *)e);
    case Event_MouseButtonRelease: return mouseReleaseEvent((QMouseEvent *)e);
    case Event_MouseMove:          return mouseMoveEvent((QMouseEvent *)e);
    case Event_KeyPress:           return keyPressEvent((QKeyEvent *)e);
    default: return this; // State remains unchanged
    }
}

EditorState *EditorState::mousePressEvent(const QMouseEvent *e)
{
    if (e->button() == LeftButton) return leftButtonPressed(e);
    else if (e->button() == MidButton) return middleButtonPressed(e);
    else if (e->button() == RightButton) return rightButtonPressed(e);
    else return this; // State remains unchanged
}


EditorState *EditorState::mouseReleaseEvent(const QMouseEvent *e)
{
    if (e->button() == LeftButton) return leftButtonReleased(e);
    else if (e->button() == MidButton) return middleButtonReleased(e);
    else if (e->button() == RightButton) return rightButtonReleased(e);
    else return this; // State remains unchanged
}


EditorState *EditorState::mouseMoveEvent(const QMouseEvent *e)
{
    return mouseMoved(e);
}


EditorState *EditorState::keyPressEvent(const QKeyEvent *e)
{
    if (e->key() == Key_Escape) {
	leave();
	return new ESNothing(mml);
    }
    else return keyPressed(e);
}
