// -*- c++ -*-
// **************************************************************
// $Source: /home/proj/mmm/cvsroot/mmm/base/ModuleMacros.h,v $
// $Revision: 1.1 $
// $Date: 1999/05/13 08:00:36 $
// $State: Exp $
// **************************************************************

/** 
 * Sorry for the mess in this file. Every household need one 
 * "put-every-junky-stuff-into-it" - drawer to make the rest
 * of the house look clean and in order.
 *
 * To keep the Module definitions lean and mean, I hacked these
 * preprocessor macros.
 */

#ifndef ModuleMacros_h
#define ModuleMacros_h

#include <string>

// Include everything that a Module normally needs.

#include "minmaxabs.h"
#include "toString.h"
#include "ModuleGenerator.h"
#include "Module.h"
#include "Slot.h"
#include "Signal.h"
#include "PreparedSoundSignal.h"
#include "PreparedNumberSignal.h"
#include "PreparedTextSignal.h"
#include "NullSound.h"
#include "PreparedDefaultNumberSignal.h"
#include "PreparedDefaultTextSignal.h"
#include "Metainfo.h"
#include "Parameterset.h"
#include "language.h"

#ifdef MODULE_NAME
#define GET_NAME string getName() const { return MODULE_NAME; };
#else
#define GET_NAME
#endif

#define BEGIN_MODULE_DEFINITION(name)		\
class M ## name : public Module			\
{						\
public:						\
    M ## name(string str="");		\
    GET_NAME

#define END_MODULE_DEFINITION(name)			\
};							\
							\
class MG ## name : public ModuleGenerator		\
{							\
    static MG ## name generator;			\
public:							\
    Module *create(string parameter="") const		\
	{ return new M ## name(parameter); };		\
    GET_NAME						\
};							\
MG ## name MG ## name::generator;

#define MODULE_DEFINITION(name)			\
BEGIN_MODULE_DEFINITION(name)			\
END_MODULE_DEFINITION(name)
    
#define MODULE_GENERATOR(name, Name)		\
class MG ## Name : public ModuleGenerator	\
{						\
public:						\
    Module *create(string parameter="") const	\
	{ return new M ## Name(parameter); };	\
    string getName() const { return name; };	\
};						\
MG ## Name mg_ ## Name;


// ---------------------------------------------------------------------------
// Helping functions or macros
// ---------------------------------------------------------------------------

inline void copySamples(const Number*& source, Number *dest, long number)
{
    memcpy(dest, source, number * sizeof(Number));
    source += number;
};


inline void fillNullSamples(Number*& dest, long number)
{
    while (number--) *dest++ = 0.0;
}


inline Number getSamplingInterval(Module *module, Metainfo *mi, const Parameterset *parset)
{
    Number si;
    if ((parset)->containsSamplingInterval())  si = (parset)->getSamplingInterval();
    else if ((mi)->containsSamplingInterval()) si = (mi)->getSamplingInterval();
    else { // considered as error
	module->reportError(l_ERR_MISSING_SAMPLING_INTERVAL_tt,
			    l_ERR_MISSING_SAMPLING_INTERVAL_tx);
	return -1.0;
    }
    if (si <= 0) {
	char number[50];
	sprintf(number, "%f", si);
	string text =
	    l_ERR_BAD_SAMPLING_INTERVAL_tx1 + string(number) +
	    l_ERR_BAD_SAMPLING_INTERVAL_tx2;
	module->reportError(l_ERR_BAD_SAMPLING_INTERVAL_tt, text.c_str());
	return si;
    }
    else return si;
}


// Get PreparedSignals, cast to demanded type and provide default PPS.

inline PreparedSoundSignal *getPreparedSoundSignal(
    Signal *tthis, Slot *slot, Metainfo *mi, const Parameterset *parset)
{
    PreparedSoundSignal *pssig = (PreparedSoundSignal *)slot->getPreparedSignal(tthis, mi, parset);
    return pssig ? pssig : NullSound::getPreparedNullSignal(mi, parset);
};

inline PreparedNumberSignal *getPreparedNumberSignal(Signal *tthis, Slot *slot, Number default_value)
{
    PreparedNumberSignal *pnsig = (PreparedNumberSignal *)slot->getPreparedSignal(tthis);
    return pnsig ? pnsig : new PreparedDefaultNumberSignal(default_value);
};

inline PreparedTextSignal *getPreparedTextSignal(Signal *tthis, Slot *slot, Text default_value)
{
    PreparedTextSignal *pnsig = (PreparedTextSignal *)slot->getPreparedSignal(tthis);
    return pnsig ? pnsig : new PreparedDefaultTextSignal(default_value);
};


#define DEFAULT_PITCH 1 // TODO: This seems not to be the right place for this

// ---------------------------------------------------------------------------

#endif // ModuleMacros_h
