// -*- c++ -*-
// **************************************************************
// $Source: /home/proj/mmm/cvsroot/mmm/base/MGPlugin.cc,v $
// $Revision: 1.1 $
// $Date: 1999/05/13 08:00:36 $
// $State: Exp $
// **************************************************************

#include "MGPlugin.h"
#include "MacroModule.h"
#include "InputModuleFile.h"

MGPlugin::MGPlugin(string filename, string menupath)
    : filename(filename), menupath(menupath)
{
    // I need to know the module's name
    InputModuleFile imf(filename.c_str());
    if (imf.isGood()) {
	LookInfo look_info;
	imf.readLookInfo(look_info);
	name = look_info.name;
	is_good = imf.isGood();
    }
}


Module *MGPlugin::create(string par) const
{
    InputModuleFile imf(filename.c_str());
    return new MacroModule(MacroModule::ET_PLUGIN, par, &imf);
}
