// -*- c++ -*-
// **************************************************************
// $Source: /home/proj/mmm/cvsroot/mmm/base/GlobalCache.h,v $
// $Revision: 1.1 $
// $Date: 1999/05/13 08:00:35 $
// $State: Exp $
// **************************************************************
// -*- c++ -*-

#ifndef GlobalCache_h
#define GlobalCache_h

#include "BasicTypes.h"
#include "DLList.h"
#include "GlobalCacheEntry.h"

class GlobalCache 
{
  enum list_type { normal, preserved };
  DLList lists[2];
  long max_allowed_size;
  long current_size;
public:
  GlobalCache(long mas) : max_allowed_size(mas), current_size(sizeof(GlobalCache)) {};
  ~GlobalCache() { lists[normal].deleteMembers(); lists[preserved].deleteMembers(); };
  void flush() { while(freeOneEntry()); }; // free all available memory
  void enter(GlobalCacheEntry *gce);
  void promote(GlobalCacheEntry *gce) 
    { gce->remove(); lists[gce->preserved ? preserved : normal].addFirst(gce); };
private:
  bool tooFull() const { return current_size > max_allowed_size; };
  void checkSize() { while (tooFull() && freeOneEntry()); }; // frees memory
  bool freeOneEntry() { return freeOneEntry(normal) || freeOneEntry(preserved); };
  bool freeOneEntry(list_type);
};

#endif // GlobalCache_h
