// -*- c++ -*-
// **************************************************************
// $Source: /home/proj/mmm/cvsroot/mmm/base/CachedSoundSignal.h,v $
// $Revision: 1.1 $
// $Date: 1999/05/13 08:00:35 $
// $State: Exp $
// **************************************************************
// -*- c++ -*-

#ifndef CachedSoundSignal_h
#define CachedSoundSignal_h

#include "AVLTree.h"
#include "SoundSignal.h"

/**
  * @ref SoundSignal, that caches its output.
  */
class CachedSoundSignal : public SoundSignal
{
  AVLTree cache;
  bool preserved; // Use preserved cache.

public:
  CachedSoundSignal(Module *m, bool p) : SoundSignal(m), preserved(p)
#ifdef STATISTICS
    , samples_looked_up(0), samples_computed(0), complete_hits(0), 
    partial_hits(0), complete_failures(0) 
#endif
    {};
  ~CachedSoundSignal() { cache.deleteMembers(); };
  SoundPortion getSoundPortion(long start_time, long nsamples, const Parameterset&);
private:
  static void copySamples(Number *source, Number *dest, long number)
     { memcpy(dest, source, number * sizeof(Number)); };

#ifdef STATISTICS
private:
  long samples_looked_up;
  long samples_computed;
  long complete_hits;
  long partial_hits;
  long complete_failures;
  void outputStatistics() const;
#endif // STATISTICS
#ifdef DEBUG
  void outputCache();
#endif // DEBUG
};


#endif // CachedSoundSignal_h
