// -*- c++ -*-
// **************************************************************
// $Source: /home/proj/mmm/cvsroot/mmm/modules/MVolumeAnalyser.cc,v $
// $Revision: 1.1 $
// $Date: 1999/05/13 08:02:16 $
// $State: Exp $
// **************************************************************

#define MODULE_NAME "volume-analyser"

#include "ModuleMacros.h"
#include "PNSigStoredNumber.h"

BEGIN_MODULE_DEFINITION(VolumeAnalyser);
    Slot *sslot_input;
    Number volume;
END_MODULE_DEFINITION(VolumeAnalyser);

class SSigVolumeAnalyserOutput : public Signal
{
    Number *volume;
public:
    SSigVolumeAnalyserOutput(MVolumeAnalyser *m, Number *volume) 
	: Signal(SOUND_TYPE, "output", "Same as input", m), volume(volume) {};
    PreparedSignal *prepareSignal(Metainfo *, const Parameterset *);
};

class NSigVolumeAnalyserVolume : public Signal
{
    Number *volume;
public:
    NSigVolumeAnalyserVolume(Module *m, Number *volume)
	: Signal(NUMBER_TYPE, "volume", "Averaged sound volume", m), volume(volume) {};
    PreparedSignal *prepareSignal(Metainfo *, const Parameterset *)
	{ return new PNSigStoredNumber(volume); };
};

class PSSigVolumeAnalyserOutput : public PreparedSoundSignal
{
    PreparedSoundSignal *pssig_input;
    Number *volume;
public:
    PSSigVolumeAnalyserOutput(PreparedSoundSignal *pssig_input, Number *volume)
	: pssig_input(pssig_input), volume(volume) {};
    ~PSSigVolumeAnalyserOutput() { delete pssig_input; };
    SoundPortion getSoundPortion(long start_time, long number_of_samples);
};


// ---------------------------------------------------------------------------
//                             Implementation
// ---------------------------------------------------------------------------

MVolumeAnalyser::MVolumeAnalyser(string)
    : volume(0)
{
    addConnector(sslot_input = new Slot(SOUND_TYPE, "input", "Input sound signal", this, 5));

    addConnector(new NSigVolumeAnalyserVolume(this, &volume));
    addConnector(new SSigVolumeAnalyserOutput(this, &volume));
}


PreparedSignal *SSigVolumeAnalyserOutput::prepareSignal(Metainfo *mi,
							const Parameterset *parset)
{
    // No parameters nor metainfo is involved
    PSSigVolumeAnalyserOutput *pps = new PSSigVolumeAnalyserOutput(
	getPreparedSoundSignal(this,  
			       ((MVolumeAnalyser *)getModule())->sslot_input, 
			       mi, parset),
	volume);
    return pps;
}

SoundPortion PSSigVolumeAnalyserOutput::getSoundPortion(long start_time, 
							long number_of_samples)
{
    SoundPortion sp = pssig_input->getSoundPortion(start_time, number_of_samples);
    
    // Now average volume and store result in *volume;
    const Number *samples = sp.getSamples();
    Number m = 0;
    int d=1;
    for (long s=0; s<number_of_samples; s+=d++)
    {
	Number a = abs(samples[s]);
	if (a > m) m = a;
    }
    *volume = m;
    return sp;
}
