#include <math.h>

#include "MScalarDisplay.h"
#include "LookMacros.h"
#include "gridspacing.h"
#include "analogdisplay.xpm"

#define GRID_WIDTH  4
#define GRID_HEIGHT 3
#define WIDTH       (GRID_SPACING * GRID_WIDTH)
#define HEIGHT      (GRID_SPACING * GRID_HEIGHT)
#define ALPHA_DEG   67.0
#define ALPHA       ((ALPHA_DEG/180.0) * M_PI)
#define TE          (HEIGHT/2+3) // GRID_SPACING
#define RADIUS      (3*HEIGHT/2 - 2) // (GRID_SPACING * 4)
#define R1          (RADIUS-3)
#define R2          (RADIUS * 0.5)

class MLAnalogScalarDisplayB : public ModuleLook
{
    QPoint last_p1, last_p2;
public:
    MLAnalogScalarDisplayB(Module *module, ModuleLookGenerator *mlg) 
	: ModuleLook(module, mlg) {};
    static void getPoints(Number, QPoint&, QPoint&);
    bool needsRepaint();
};

class MLGAnalogScalarDisplayB : public ModuleLookGenerator
{
    QPixmap *pixmap;
public:
    MLGAnalogScalarDisplayB() { pixmap = 0; };
    ~MLGAnalogScalarDisplayB() { if (pixmap) delete pixmap; };
    ModuleLook *create(Module *module) { return new MLAnalogScalarDisplayB(module, this); };
    string getName() const { return "analog-scalar-display-b"; };
    const char *menuPath() const { return "Display/Scalar"; }
    QSize gridSize() const { return QSize(4,3); };
    void paint(QPainter&, Module *);
};

MLGAnalogScalarDisplayB mlg_AnalogScalarDisplayB;

// ----------------------------------------------------------------------

void MLAnalogScalarDisplayB::getPoints(Number value, QPoint& p1, QPoint& p2)
{
    value = min(max(value, -1), 1);
    double omega = ALPHA + (M_PI - 2.0 * ALPHA) * ( (-value + 1.0) / 2 );
    p1 = QPoint((short)(cos(omega) * R1) + WIDTH/2, TE + HEIGHT - (short)(sin(omega) * R1));
    p2 = QPoint((short)(cos(omega) * R2) + WIDTH/2, TE + HEIGHT - (short)(sin(omega) * R2));
}

bool MLAnalogScalarDisplayB::needsRepaint()
{
    // Per definition of needsRepaint() I assume, that I will be painted.
    // In paint()
    // I have no access to the MLAnalogScalarDisplayB, but only to the
    // MScalarDisplay!

    Number value = ((MScalarDisplay *)getModule())->getValue();
    QPoint new_p1, new_p2;
    getPoints(value, new_p1, new_p2);
    if (new_p1 != last_p1 || new_p2 != last_p2)
    {
	last_p1 = new_p1;
	last_p2 = new_p2;
	return true;
    }
    else return false;
}

void MLGAnalogScalarDisplayB::paint(QPainter& p, Module *module)
{
    if (!pixmap) pixmap = new QPixmap((const char **)analogdisplay_xpm);
    p.drawPixmap(0, 0, *pixmap);

    QPoint p1, p2;
    if (module) {
	MScalarDisplay *msd = (MScalarDisplay *)module;
	MLAnalogScalarDisplayB::getPoints(msd->getValue(), p1, p2);
    }
    else
	MLAnalogScalarDisplayB::getPoints(0.33, p1, p2);

    p.setPen(black);
    p.drawLine(p1, p2);
}
