// -*- c++ -*-
// **************************************************************
// $Source: /home/proj/mmm/cvsroot/mmm/editor/ESWireing.h,v $
// $Revision: 1.1 $
// $Date: 1999/05/13 08:14:34 $
// $State: Exp $
// **************************************************************

#ifndef ESWireing_h
#define ESWireing_h

#include "EditorState.h"

#include <qobject.h>
class MacroModuleLook;
class ModuleLook;
class Connector;

class ESWireing : QObject, public EditorState
{
    Q_OBJECT
    ModuleLook *module_look;
    Connector  *connector;
    QPoint      mouse_position;
    
public:
    ESWireing(MacroModuleLook *mml, ModuleLook *module_look, Connector *connector);
    EditorState *finishWireing(int connector_id);
    Connector   *getConnector() { return connector; };
    ModuleLook  *getModuleLook() { return module_look; };

protected:
    void enter();
    void leave();
    void paintEvent(QPainter&, const QRect&);
    EditorState *mouseMoved(const QMouseEvent *);
    EditorState *leftButtonPressed (const QMouseEvent *);
    EditorState *middleButtonPressed (const QMouseEvent *);

private:
    void draw() const;
    void draw(QPainter&) const;
};

#endif // ESWireing_h
