// -*- c++ -*-
// **************************************************************
// $Source: /home/proj/mmm/cvsroot/mmm/editor/ESDraggingModules.cc,v $
// $Revision: 1.1 $
// $Date: 1999/05/13 08:14:34 $
// $State: Exp $
// **************************************************************

#include "ESDraggingModules.h"
#include "ESNothing.h"
#include "MacroModuleLook.h"
#include "gridspacing.h"

ESDraggingModules::ESDraggingModules(MacroModuleLook *mml, QPoint start_position)
    : EditorState(mml)
    , start_position(start_position)
{
}

EditorState *ESDraggingModules::leftButtonReleased(const QMouseEvent *)
{
    return new ESNothing(mml);
}


EditorState *ESDraggingModules::mouseMoved(const QMouseEvent *event)
{
    // if the difference between the dragging_start_position and the
    // current mouse position exceeds the half grid with in either x-
    // or y-direction, i move all selected elements
    
    QPoint drag_vector = (event->pos() - start_position)
	+ QPoint(GRID_SPACING / 2, GRID_SPACING / 2);
    
    if (drag_vector.x() < 0) drag_vector.rx() -= GRID_SPACING;
    if (drag_vector.y() < 0) drag_vector.ry() -= GRID_SPACING;
    QPoint grid_drag_vector = drag_vector / GRID_SPACING;
    if (!grid_drag_vector.isNull()) {
	if (mml->dragSelectedModules(grid_drag_vector))
	    start_position += grid_drag_vector * GRID_SPACING;
    }
    return this;
}
