// -*- c++ -*-
// **************************************************************
// $Source: /home/proj/mmm/cvsroot/mmm/editor/ESDraggingLayoutRect.cc,v $
// $Revision: 1.1 $
// $Date: 1999/05/13 08:14:34 $
// $State: Exp $
// **************************************************************

#include "ESDraggingLayoutRect.h"
#include "ESNothing.h"
#include "rectutils.h"
#include "MacroModuleLook.h"

ESDraggingLayoutRect::ESDraggingLayoutRect(MacroModuleLook *mml, 
					   QPoint start_position, DragPosition drag_position)
    : EditorState(mml)
    , start_position(start_position)
    , drag_position(drag_position) 
{
}

void ESDraggingLayoutRect::enter()
{
    mml->needsUpdateLayoutRect();
}

void ESDraggingLayoutRect::leave()
{
    mml->needsUpdateLayoutRect();
}


void ESDraggingLayoutRect::paintEvent(QPainter& p, const QRect& update_rect)
{
    QRect rect = enlargeRect(mml->layoutRect() * 2 * GRID_SPACING, LAYOUT_RECT_THICKNESS - 1);
    p.save();
    p.setPen(QPen(yellow, 3, SolidLine));
    p.drawRect(rect);
    p.restore();
}

EditorState *ESDraggingLayoutRect::leftButtonReleased(const QMouseEvent *)
{
    return new ESNothing(mml);
}


EditorState *ESDraggingLayoutRect::mouseMoved(const QMouseEvent *event)
{
    QPoint offset = mml->nearestGridPosition(event->pos() - start_position, 2);
    if (offset.x() != 0 || offset.y() != 0)
    {
	QRect old_rect = mml->layoutRect();
	if (drag_position & LEFT)   mml->setLayoutRect(resizeLeft  (mml->layoutRect(), offset.x()));
	if (drag_position & RIGHT)  mml->setLayoutRect(resizeRight (mml->layoutRect(), offset.x()));
	if (drag_position & TOP)    mml->setLayoutRect(resizeTop   (mml->layoutRect(), offset.y()));
	if (drag_position & BOTTOM) mml->setLayoutRect(resizeBottom(mml->layoutRect(), offset.y()));
	if (old_rect != mml->layoutRect())
	{
	    start_position = 
		QPoint(start_position.x() + offset.x() * 2 * GRID_SPACING,
		       start_position.y() + offset.y() * 2 * GRID_SPACING);
	}
    }
    return this;
}

