// -*- c++ -*-
// **************************************************************
// $Source: /home/proj/mmm/cvsroot/mmm/editor/ESCarryingForInsertion.cc,v $
// $Revision: 1.2 $
// $Date: 1999/05/16 19:14:53 $
// $State: Exp $
// **************************************************************

#include "ESCarryingForInsertion.h"
#include "ESNothing.h"
#include "ModuleLookGenerator.h"
#include "MacroModuleLook.h"
#include "gridspacing.h"
#include "rendering.h"

ESCarryingForInsertion::ESCarryingForInsertion(MacroModuleLook *mml, 
					       ModuleLookGenerator *module_look_generator)
    : EditorState(mml)
    , module_look_generator(module_look_generator)
    , module_look(0)
    , grid_position(0,0)
    , size(module_look_generator->size())
{
}

ESCarryingForInsertion::ESCarryingForInsertion(MacroModuleLook *mml, 
					       ModuleLook *module_look)
    : EditorState(mml)
    , module_look_generator(0)
    , module_look(module_look)
    , grid_position(0,0)
    , size(module_look->size())
{
}

ESCarryingForInsertion::~ESCarryingForInsertion()
{
    if (module_look) {
	delete module_look->getModule();
	delete module_look;
    }

}


void ESCarryingForInsertion::enter()
{
    mml->setMouseTracking(TRUE);
}


void ESCarryingForInsertion::leave() 
{
    needsUpdate();
    mml->setMouseTracking(FALSE);
}


void ESCarryingForInsertion::paintEvent(QPainter& p, const QRect&)
{
    p.save();
    p.translate(grid_position.x() * GRID_SPACING,
		grid_position.y() * GRID_SPACING);
    if (module_look_generator) module_look_generator->paintRubberBorder(p);
    else ::paintRubberBorder(p, size);
    p.restore();
}

EditorState *ESCarryingForInsertion::mouseMoved(const QMouseEvent *event)
{
    QPoint midpos = event->pos();
    midpos.rx() -= size.width() / 2;
    midpos.ry() -= size.height() / 2;

    QPoint new_gridpos = mml->nearestGridPosition(midpos);
    QSize grid_size = module_look_generator 
	? module_look_generator->gridSize()
	: module_look->gridSize();

    if (new_gridpos != grid_position && mml->canvasRect().contains(QRect(new_gridpos, grid_size)))
    {
	needsUpdate();
	grid_position = new_gridpos;
	needsUpdate();
    }
    return this;
}


EditorState *ESCarryingForInsertion::leftButtonPressed(const QMouseEvent *)
{
    needsUpdate();
    if (module_look_generator)
	mml->createAndInsertModule(module_look_generator, grid_position);
    else {
	module_look->getModule()->moveTo(grid_position.x(), grid_position.y());
	mml->macromodule->addModule(module_look->getModule());
	mml->addModuleLook(module_look);
	module_look = 0; // Tell desctructor not to delete it!
    }
    return new ESNothing(mml);
}

void ESCarryingForInsertion::needsUpdate()
{
    mml->needsUpdate(QRect(GRID_SPACING * grid_position, size));
}
