// -*- c++ -*-
// **************************************************************
// $Source: /home/proj/mmm/cvsroot/mmm/base/Wire.h,v $
// $Revision: 1.2 $
// $Date: 1999/05/15 22:48:23 $
// $State: Exp $
// **************************************************************

#ifndef Wire_h
#define Wire_h

#include "DLList.h"

class Connector;
class Module;

/**
  * @short Allows @ref MacroModule to store a list of all its wires.
  * Each wire connects a signal of a module with a slot of another (or
  * the same) module.
  */
class Wire : public DLListNode
{
    /**
      * Connected signal.
      */
    Connector *signal;

    /**
      * Connected slot.
      */
    Connector *slot;
    
    /**
     * Module that contains the connected signal. If the signal is external
     * then this is different from signal->getModule()!
     */
    Module *signal_module;

    /**
     * Module that contains the connected signal. If the slot is external
     * then this is different from signal->getModule()!
     */
    Module *slot_module;

    friend class MacroModule;

public:
    /**
      * Constructs a new Wire that MUST be insertet into a DLLList,
      * since the destructor calls @ref DLListNode::remove.
      */
    Wire(Connector *, Connector *, Module *, Module *);

    /**
      * Removes the wire from the list it is in.
      */
    ~Wire() { remove(); };

    /**
     * Returns the Signal this wire is connected to
     */
    const Connector *getSignal() const { return signal; };

    /**
     * Returns the Slot this wire is connected to.
     */
    const Connector *getSlot() const { return slot; };

    const Module *getSignalModule() const { return signal_module; };

    const Module *getSlotModule() const { return slot_module; };

    bool bothModulesAreSelected() const;

    bool isConnectedTo(const Module *module) const;
};


#endif // Wire_h
