// -*- c++ -*-
// **************************************************************
// $Source: /home/proj/mmm/cvsroot/mmm/base/SoundPortion.h,v $
// $Revision: 1.1 $
// $Date: 1999/05/13 08:00:37 $
// $State: Exp $
// **************************************************************

#ifndef SoundPortion_h
#define SoundPortion_h

#include "SharedStore.h"
#include "BasicTypes.h"

class SoundPortion
{
    SharedStore *shared_store;
    Number      *samples;
public:
    SoundPortion(Number *, SharedStore *);
    SoundPortion(const SoundPortion&);
    SoundPortion& operator = (SoundPortion&);
    ~SoundPortion() { shared_store->unreference(); };
    const Number *getSamples() const { return samples; };
};


inline SoundPortion::SoundPortion(Number *d, SharedStore *ss)
    : shared_store(ss),
      samples(d)
{
    shared_store->reference();
}


inline SoundPortion::SoundPortion(const SoundPortion& sp)
    : shared_store(sp.shared_store),
      samples(sp.samples)
{
    shared_store->reference();
}


inline SoundPortion& SoundPortion::operator = (SoundPortion& sp)
{
    shared_store->unreference();
    shared_store = sp.shared_store;
    shared_store->reference();
    samples = sp.samples;
    return *this;
}

#endif // SoundPortion_h

