// -*- c++ -*-
// **************************************************************
// $Source: /home/proj/mmm/cvsroot/mmm/base/Slot.cc,v $
// $Revision: 1.1 $
// $Date: 1999/05/13 08:00:37 $
// $State: Exp $
// **************************************************************

#include "Slot.h"
#include "Signal.h"
#include "PreparedSignal.h"

Slot::Slot(SignalType type, string name, string description, Module *m, short wirecolor) 
    : Connector(type, name, description, m)
    , wirecolor(wirecolor)
    , wired_to(0)
    , is_parameter(false)
    , currently_being_computed(0) 
{
}


Slot::~Slot()
{
}


Signal *Slot::getSignal(Signal *cbc)
{
    if (wired_to != 0) return wired_to;
    else if (is_parameter && cbc) 
	return cbc->getParameterSignal(getName().c_str());
    else return 0;
}


Signal *Slot::getParameterSignal(const char *name)
{
    if (currently_being_computed) return currently_being_computed->getParameterSignal(name);
    else return 0;
}


void Slot::wireTo(Signal *s)   
{
    is_parameter = false; 
    wired_to = s; 
}


void Slot::makeParameter()  
{ 
    is_parameter = true;
    wired_to = 0; 
}


void Slot::disconnect()        
{ 
    is_parameter = false;
    wired_to = 0; 
}


bool Slot::isConnected() const 
{ 
    return is_parameter || wired_to != 0; 
}

bool Slot::isParameter() const 
{ 
    return is_parameter; 
}


short Slot::getWireColor() const 
{
    return wirecolor; 
}


PreparedSignal *Slot::getPreparedSignal(Signal *cbc, Metainfo *mi=0, const Parameterset *parset=0)
{
    if (currently_being_computed) *(long *)0xdeadbeaf = 0xfea1dead; // TODO: handle error nicer
    currently_being_computed = cbc;
    
    PreparedSignal *result;

    Signal *signal = getSignal(currently_being_computed);
    if (signal) result = signal->getPreparedSignal(this, mi, parset);
    else        result = 0;

    currently_being_computed = 0;
    return result;
}



