// -*- c++ -*-
// **************************************************************
// $Source: /home/proj/mmm/cvsroot/mmm/base/DLList.h,v $
// $Revision: 1.1 $
// $Date: 1999/05/13 08:00:35 $
// $State: Exp $
// **************************************************************

#ifndef DLList_h
#define DLList_h

/**
  * @short Base class for objects stored in a DLList.
  */ 
class DLListNode
{
    friend class DLList;
    DLListNode *previous;
    DLListNode *next;
public:
    virtual ~DLListNode() {}; // Base class must have virtual destructor    
    DLListNode *getPrevious() const { return previous; }; // act as list node
    DLListNode *getNext() const { return next; };         // act as list node
    void remove() { previous->next = next; next->previous = previous; };
};

// DLList ist a DLListNode that acts as a head and tail node in one,
// but contains no user information. The list is organized like a
// ring. If the list is empty, it contains only the head-tail-node. A
// DLListNode itself cannot determine, whether it's the first or last
// of the list. But due to this concept, it is unneccessary to handle
// special cases.  In the DLList the inherited variables previous and
// next have intuitionally the meaning of "last" and "first". In the
// empty list both pointers point to the head-tail-node node itself.

/**
  * @short Doubly linked list.
  */
class DLList : private DLListNode
{
public:
    DLList() { previous = this; next = this; };
    void deleteMembers() { while (!isEmpty()) delete getFirst(); }; // members MUST have remove() in their destructor!
    bool isEmpty() const { return previous == (DLListNode *)this; };
    DLListNode *getFirst() const { return next; };
    DLListNode *getLast() const { return previous; };
    bool isFirst(DLListNode *n) const { return n->previous == (DLListNode *)this; };
    bool isLast(DLListNode *n) const { return n->next == (DLListNode *)this; };
    /**
     * True, if this DLListNode is the head of the list. When you scan a list
     * you can use this condition to detect the end of the list.
     */
    bool isEndOfList(const DLListNode *n) const { return n == (DLListNode *)this; };
    void addFirst(DLListNode *n) { 
	n->next = next; 
	n->previous = this;
	next->previous = n;
	next = n;
    };
    void addLast(DLListNode *n) {
	n->next = this;
	n->previous = previous;
	previous -> next = n;
	previous = n;
    };
    int count() const;
};

#endif // DLList_h
