/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Thu Sep 30 1999
    copyright            : (C) 1999 by Ralf Nolden
    email                : Ralf.Nolden@post.rwth-aachen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/* -----  main.cpp  -----
   ktuner v0.5 , Copyright (c) 1998 Carl van Schaik
   e-mail carl@leg.uct.ac.za
          navlrac@hotmail.com
          cvansch@eng.uct.ac.za

   Radiotrack II implementation : Leendert Meyer (leendert@usa.net).

   RadioTrack II Protocol : Ben Pfaff

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   This applies to all files in the distribution
   main.cpp kRadio.cpp, kRadio.h, conf.h, conf.cpp, hardware.h, hardware.cpp

   Please, if you do decide to rip-off this program, give credits to me
   those people (mentioned in README). We have worked very long and
   hard to produce this software

   This software uses the qt librays by troll tech (www.troll.no) and
   does not comply to the GPL. Hopefully, I can get a copy of qt-free
   soon.
*/

#include "ktuner.h"
#include <qmsgbox.h>
#include <qimage.h>
#include <kapp.h>

radioCard  *card;
configFile *config;

KApplication  *base;
Radio         *Panel;
DockWidget    *dock_widget;


int main( int argc, char **argv )
{
   base = new KApplication( argc, argv );
   base->setFont(QFont("helvetica",10,QFont::Normal));

//   QWidget *logo = new QWidget();

   int errNum=0;

   config = new configFile();
   errNum = config->readin();

   if (errNum==0)
     {
       int errNum = 0;
       int cardType = config->getCardType();

       if (cardType == RADIOTRACK)
         card = new rtrack(config);
       else if (cardType == RADIOTRACKII)
         card = new rtrackII(config);
       else if (cardType == ZOLTRIX)
         card = new zoltrix(config);
#ifdef LINUX
  #ifdef USE_KERNEL
       else if (cardType == KERNELDEV)
         card = new kernelCard(config);
  #else
       else if (cardType == KERNELDEV)
           errNum=41;
  #endif //USE_KERNEL
#endif //LINUX
       else
         errNum = 27;

       errNum = card->init(config->noVolSet(),config->noDefSet());
     }

   QMessageBox errMsg;

   if (errNum != 0)
     {
       errMsg.setFont(QFont("helvetica",12,QFont::Bold));

       optionBox opt(config,card);
       int o=0;

       switch (errNum)
	 {
	   case 1 : errMsg.setText("Error : Specified port is invalid for selected card"); o=1; break;
	   case 2 : errMsg.setText("I need IO rights : run as root or set setuidi as root"); o=1; break;
	   case 20: errMsg.setText("Error, invalid base port in configuration"); o=1; break;
	   case 21: errMsg.setText("Error, unsupported radio card in configuration"); o=1; break;
	   case 22: errMsg.setText("Error, volume setting out of range"); o=1; break;
	   case 23: errMsg.setText("Error, default channel setting out of range"); o=1; break;
	   case 24: errMsg.setText("Error, channel in configuration invalid"); o=1; break;
	   case 25: errMsg.setText("Error, channel frequency out of range"); o=1; break;
	   case 26: errMsg.setText("Error, channel name not found"); o=1; break;
	   case 27: errMsg.setText("Error, invalid card type in configuration"); o=1;; break;
	   case 28: errMsg.setText("Error, sleep time too long or invalid"); o=1; break;
	   case 29: errMsg.setText("Error, invalid alarm time specified"); o=1; break;
	   case 30: errMsg.setText("Warning, A card not detected on specified port"); o=1; break;
	   case 40: errMsg.setText("Error, could not open /dev/radio"); o=1; break;

           default: errMsg.setText("An unknown error has occured");
	 }

       errMsg.setIcon(QMessageBox::Critical);
       //       errMsg.setStyle(WindowsStyle);
       errMsg.show();
       if (o)
	 {
	   opt.show();
	   base->setMainWidget(&opt);
	   return base->exec();
	 }
       else
	 exit(0);
     }

   if (errNum == 0)
     {
       dock_widget = new DockWidget("dockw");
       Panel = new Radio (config, card);
       Panel->resize(400,90);
       QImage temp1((const char**)kIcon);
       QPixmap temp2;
       temp2 = temp1;
       Panel->setIcon(temp2);
       base->setMainWidget(Panel); 
       Panel->show();
       return base->exec();
     }
}

void Radio::closeEvent( QCloseEvent *e )
{
  if (1 /*allowDocking*/ ) {
    dock_widget->dock();
    this->hide();
  }
  else{
    e->ignore();
  }
}
