	/*

	Copyright (C) 1998 Stefan Westerfeld
                       stefan@space.twc.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    */

#include "module.h"
#include "utils.h"

ModulePort::ModulePort(Module *owner, char *description, int portnr, Direction direction)
{
	selected = false;

	this->owner = owner;				// whats the syntax for that again?
	this->portnr = portnr;
	this->direction = direction;

	isinitarg = (description[0] == '_');
	if(isinitarg)
		this->description = description+1;		// skip the underscore
	else
		this->description = description;
	conntype = none;
	connvalue = 0.0;
	route_owner = 0;
	strvalue = "";
}

QString ModulePort::getID()
{
	QString id,dstr;

	if(direction == in) dstr = "in"; else dstr = "out";

	printf("portnr = %d, dstr = %s  => id =",portnr,dstr.data());
	id.sprintf("%s_%sport%d",owner->getID().data(),dstr.data(),portnr);
	printf("%s\n",id.data());
	return(id);
}

void ModulePort::save(KSimpleConfig& out)
{
	out.setGroup(getID().data());

	out.writeEntry("connvalue",connvalue);
	out.writeEntry("strvalue",strvalue);
	switch(conntype)
	{
		case none: out.writeEntry("conntype","none");
			break;
		case dest: out.writeEntry("conntype","dest");
				   out.writeEntry("connmodule",connection->getID());
			break;
		case source: out.writeEntry("conntype","source");
			break;
		case value: out.writeEntry("conntype","value");
			break;
	}
}

void ModulePort::load(KSimpleConfig& in, list<Module *> ModuleList)
{
	in.setGroup(getID().data());

	connvalue = in.readDoubleNumEntry("connvalue");
	strvalue = in.readEntry("strvalue");

	QString str_conntype(in.readEntry("conntype"));

	if(str_conntype == "none") conntype = none;
	if(str_conntype == "dest")
	{
		QString connmodule = in.readEntry("connmodule");

		connection = NULL;
		conntype = dest;
		list<Module *>::iterator mi;
		for(mi=ModuleList.begin();mi!=ModuleList.end();mi++)
		{
			ModulePort *otherport = (*mi)->findPort(connmodule);

			if(otherport) connection = otherport;
		}

		if(!connection)
		{
			fprintf(stderr,"PANIC: connecting to object which is not there\n");
			conntype = none;
		}
	}
	if(str_conntype == "source") conntype = source;
	if(str_conntype == "value") conntype = value;
}

QString ModulePort::portVal()
{
	QString result;

	if(isinitarg)
	{
		result = "\"";
		result += strvalue;
		result += "\"";
	}
	else
	{
		if(conntype == none) result = "0.0";
		if(conntype == dest)
			result = connection->owner->getID() + "." + connection->description;

		if(conntype == value)
			result.setNum(connvalue);
	}

	assert(conntype != source);
	return(result);
}

Module::Module(ModuleInfo *minfo)
{
	int i;
	QString iconname;

	selected = false;
	height = 1;
	type = minfo->name;
	pixmap = NULL;

// test if pixmap available

	iconname = type+".xpm";
	FILE *test=fopen(iconname.data(),"r");
	if(test)
	{
		pixmap = new QPixmap(iconname);
		fclose(test);
	}
	
// create lists with inports & outports for this module
// and bind them to it ...

	for(i=0;i<minfo->inports.length();i++)
	{
		ModulePort *p;

		p = new ModulePort(this,(char *)minfo->inports[i],i,ModulePort::in);
		inports.push_back(p);
	}

	for(i=0;i<minfo->outports.length();i++)
	{
		ModulePort *p;

		p = new ModulePort(this,(char *)minfo->outports[i],i,ModulePort::out);
		outports.push_back(p);
	}

	width = 1+imax(inports.size(),outports.size()+1);
}

void Module::save(KSimpleConfig &out)
{
	out.setGroup(getID().data());

	out.writeEntry("x",x);
	out.writeEntry("y",y);
	out.writeEntry("selected",selected);
	out.writeEntry("type",type.data());

	int i;
	list<ModulePort *>::iterator port;

	for(i=0, port=inports.begin();port != inports.end(); port++,i++)
		(*port)->save(out);

	for(i=0, port=outports.begin();port != outports.end(); port++,i++)
		(*port)->save(out);
}

void Module::load(KSimpleConfig &in)
{
	in.setGroup(getID().data());

	x = in.readNumEntry("x");
	y = in.readNumEntry("y");
	selected = in.readBoolEntry("selected");
}

void Module::loadPorts(KSimpleConfig &in, list<Module *> ModuleList)
{
	int i;
	list<ModulePort *>::iterator port;

	for(i=0, port=inports.begin();port != inports.end(); port++,i++)
		(*port)->load(in, ModuleList);

	for(i=0, port=outports.begin();port != outports.end(); port++,i++)
		(*port)->load(in, ModuleList);
}

QString Module::getID()
{
	QString id;

	id.sprintf("module%d",modnr);
	return(id);
}

QString Module::execute()
{
	QString command;
	list<ModulePort *>::iterator i;
	bool addc = false;

// example:
//   create freq1m = Synth_FM_SOURCE(fm.outvalue,sin1.outvalue,osm1.outvalue);

	printf("entering execute...\n");
	command.sprintf("create %s = %s(",getID().data(),type.data());
	
	printf("looking for ports ...\n");
	for(i=inports.begin();i != inports.end();i++)
	{
		if(addc) command += ','; addc = true;
		command += (*i)->portVal();
	}

	printf("preparing to go ...\n");
	command += ");";
	printf("done ...\n");
	return(command);
}

ModulePort *Module::findPort(QString id)
{
	list<ModulePort *>::iterator i;

	for(i=inports.begin();i != inports.end();i++)
		if((*i)->getID() == id) return(*i);

	for(i=outports.begin();i != outports.end();i++)
		if((*i)->getID() == id) return(*i);

	return(NULL);
}

/*
ModulePort *Module::findPort(int xoffset, Direction direction)
{
	list<ModulePort *> *ports;
	list<ModulePort *>::iterator i;

	int n;

	if(direction == 0) ports = &m->inports; else ports = &m->outports;

	i = ports->begin();
	n = xoffset-1-direction;

	if(n<ports->size() && n>=0)
	{
		while(n>0) { n--; i++; }
		return(*i);
	}
	return(NULL);
}
*/
