/*
 *	      StopWatch - a stopwatch for kmikmod
 *	(C)1998, 1999 Roope Anttinen - roope.anttinen@ntc.nokia.com
 *	
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 */

#ifndef _StopWatch_H
#define _StopWatch_H

#ifndef _MIT_POSIX_THREADS
# define _MIT_POSIX_THREADS
#endif
#ifndef _REENTRANT
# define _REENTRANT
#endif

#include <time.h>
#include <pthread.h>

class StopWatch {

private:
	time_t Started;
	time_t Paused;
	bool paused;
	bool stopped;
	pthread_mutex_t ST_mutex;

public:
	StopWatch();
	~StopWatch();
	void start();
	void pause(bool = true);
	void stop();
	void step(int);
	time_t elapsed ();
};

#endif // _StopWatch_H
