/*	MikMod sound library
	(c) 1998, 1999 Miodrag Vallat and others - see file AUTHORS for
	complete list.

	This library is free software; you can redistribute it and/or modify
	it under the terms of the GNU Library General Public License as
	published by the Free Software Foundation; either version 2 of
	the License, or (at your option) any later version.
 
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU Library General Public License for more details.
 
	You should have received a copy of the GNU Library General Public
	License along with this library; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
	02111-1307, USA.
*/

/*==============================================================================

  $Id: mdreg.c,v 1.23 1999/03/24 06:00:06 miod Exp $

  Routine for registering all drivers in libmikmod for the current platform.

==============================================================================*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <mikmod_internals.h>

void _mm_registeralldrivers(void)
{
	/* Register network drivers */
#ifdef DRV_AF
	_mm_registerdriver(&drv_AF);
#endif
#ifdef DRV_ESD
	_mm_registerdriver(&drv_esd);
#endif

	/* Register hardware drivers - hardware mixing */
#ifdef DRV_ULTRA
	_mm_registerdriver(&drv_ultra);
#endif

	/* Register hardware drivers - software mixing */
#ifdef DRV_AIX
	_mm_registerdriver(&drv_aix);
#endif
#ifdef DRV_ALSA
	_mm_registerdriver(&drv_alsa);
	_mm_registerdriver(&drv_alsathr);
#endif
#ifdef DRV_HP
	_mm_registerdriver(&drv_hp);
#endif
#ifdef DRV_OSS
	_mm_registerdriver(&drv_oss);
	_mm_registerdriver(&drv_ossthr);
#endif
#ifdef DRV_SGI
	_mm_registerdriver(&drv_sgi);
#endif
#ifdef DRV_SUN
	_mm_registerdriver(&drv_sun);
#endif
#ifdef DRV_DART
	_mm_registerdriver(&drv_dart);
#endif
#ifdef DRV_OS2
	_mm_registerdriver(&drv_os2s);
	_mm_registerdriver(&drv_os2l);
#endif
#ifdef DRV_DS
	_mm_registerdriver(&drv_ds);
#endif

	/* Register disk writers */
	_mm_registerdriver(&drv_raw);
	_mm_registerdriver(&drv_wav);

	/* Register other drivers */
	_mm_registerdriver(&drv_stdout);

	_mm_registerdriver(&drv_nos);
}

void MikMod_RegisterAllDrivers(void)
{
	MUTEX_LOCK
		_mm_registeralldrivers();
	MUTEX_UNLOCK
}

/* ex:set ts=4: */
