/*
  this is a EventQueue. Every device has its own EventQueue.
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#ifndef __EVENTQUEUE_H
#define __EVENTQUEUE_H

#include <pthread.h>

#include <qsocketnotifier.h> 
#include <iostream.h>
#include <unistd.h>
#include <fcntl.h>


#include <signal/toolkit/notifyClient.h>
#include <signal/toolkit/yafObject.h>



#define _NOTIFY_ALL       1
#define _NOTIFY_IF_CLEAR  2
#define _NOTIFY_NO        3


#define _GLOBAL_EVENT_SYNC        127

/**
   This EventQueue class is used by each NodeDevice. Each NodeDevice
   has a sperate EventQueue. The EventQueue offers a mechanism
   that the delivering thread, the thread which walks from the
   Producer through the whole device graph, can notify the
   GUI about the state of the device.
   <p>
   This EventMechanism must be thread safe. The EventQueue class
   must be implemented by each toolkit (QT/GTK) because
   every toolkit has its own signal mechanism.
   <p>
   The device can only write into the queue and the GUI can only
   read out the queue.
   If the GUI must make manipulations on the device it must
   do it directly, by calling the offered methods by the
   device. The device must make sure, that these calls are 
   threadsafe.
   <p>
   What are notifymodes?<p>
   With notifymodes you can specify under what circumstances a 
   event is delivered.
   <p>
   _NOTIFY_ALL<p>
   means that every event generated by a devices is delivered.
   _NOTIFY_IF_CLEAR<p>
   means that an event is only send if the gui has cleared the previous
   event.
   <p>
   The difference is clear. In most situatiosn the gui cannot update
   as fast as the data is send through the yaf-graph. Eg: A videostream
   produces 25 frames/second. But your X server is slow. And he can
   only paint 10 frames a second. If the movie is exactly one second
   long you see :<p>
   with _NOTIFY_ALL 10 frames and then 15 times a refresh of the last frame
   <p>
   with _NOTIFY_IF_CLEAR 10 frames.<p>
   Another examples is: if the gui is not interested in all the data.
   Eg: A time widget. The user is interested in  updates for ever second.
   With _NOTIFY_ALL the gui would get 25 updates. Because every single
   frame generates an event.
   The default value for deliver mode is _NOTIFY_IF_CLEAR. This is
   the best for all situations, but the GUI must clear() the "notifyBit".
   <p>
   The notify client is a signal mechanism independent way how
   the yaf library can get the GUI events. The yaf library does not
   have a supperior signal mechanism model. It simply uses sender/listener
   methods. The listener registerd itsself with an interface and
   the sender calls a method on this interface.
   The addListener method may be useful in a dataGenerator.
   Note: 
   <p>
   all eventId higher than 127 are forwarded as global events.The event
   127 is reserved for global event synchronisation.
   It is send to the global receivers but not over the global
   eventqueue but through a local "emit" signal.
   
   
*/

class EventQueue : public YafObject {
  Q_OBJECT

  QSocketNotifier *sn;
  int fd[2];
  pthread_mutex_t dataMut;
  int lData;
  int mode;
  int ldebug;
  NotifyClient* client;
  char* owner;

 public:
  EventQueue(char* owner);
  ~EventQueue();

  // called by device-thread:
  void sendEvent(unsigned char eventId);
  void setNotifyMode(int mode);
  void clearNotifyBit();
  int getNotifyBit();

  void setDebug(int flag);
  void addListener(NotifyClient* client);

 public slots:
  void receiveEvent(int);
};

#endif


  
