/*
  the yaf generator interface works together with yaf backend players
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#ifndef __YAFGENERATOR_H
#define __YAFGENERATOR_H
#include <pthread.h>

#include <producer/core/dataGenerator.h>
#include <deviceConfig/deviceConfig.h>
#include <util/controlChannel.h>
#include <yafxplayer/xplayerRuntime.defs>
#include <producer/yaf/yafXPlayerControl.h>
#include <producer/yaf/yafStream.h>

#include <signal/toolkit/eventQueue.h>


#define _EMIT_EOF_EVENT            1
#define _EMIT_STOP_EVENT           2
#define _EMIT_PLAY_EVENT           3
#define _EMIT_PAUSE_EVENT          4
#define _EMIT_BUFFER_EVENT         5
#define _EMIT_DECODER_EOF_EVENT    6
#define _EMIT_CLEAR_STREAM_EVENT   7



/**
  
  Note:<p>
  This generator produces data which are delivered by a yaf-protocol
  compliant <xyz>-player.
  The StreamProducer enter this class as a sperate thread and this
  yafGenerator make sure that the thread gets valid deviceConfig
  entries.
  <p>


  The yaf interface is a bit complex because it must handle
  a command line yaf-player.For simplier examples look in the
  imageGenerator.
  <p>
*/


class YafGenerator :  public DataGenerator,
		             ControlChannel,
                             NotifyClient   {
  DeviceConfig* config;
  MusicInfo* musicInfo;
  AudioInfo* audioInfo;
  AudioBuffer* audioBuffer;
  TimeInfo* timeInfo;
  StatusInfo* statusInfo;
  EventQueue* eventQueue;

  YafXPlayerControl* control;
  struct YafStream* stream;
  int instanceCnt;
  int statusPipe[2];

 public:
  YafGenerator();
  ~YafGenerator();

  int updateDeviceConfig(DeviceConfig* newConfig);

  int open(char* filename );
  int close();
  int play();
  int pause();
  int jump(int);


  // Not a part of the Producer interface.
  // These things are special for the yafInterface:

  void processRuntimeCommand(int command,char* args);
  void processReturnCommand(int cmdNr,int cmdId,char* ret,char* args);

  void addArgument(char* arg);
  void startDecoder();

  void bufferFilledNotify(int filled);  // called by yafStream after underrun
  void setThreadState(int msg);

  
  void processEvent(char msgId);

 private:
  void clearStream();
  void dataUpdate();

  int lClearRequest;
  int pauseCmdNr;
  int fullUpdate;
  int lPlayRequest;
  long eofBytes;

};

#endif
