/*
  what do you thing this class does? hm. If its name "volumefilter"
  Copyright (C) 1999 Rainer Maximini, Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include <filter/volumeFilter.h>


VolumeFilter::VolumeFilter() {
}


VolumeFilter::~VolumeFilter() {
}

void VolumeFilter::transform(DeviceConfig* config) {
  AudioStream* audioStream=config->getAudioStream();
  VolumeInfo* volumeInfoStream=audioStream->getVolumeInfo();
  AudioInfo* audioInfo=audioStream->getAudioInfo();
  
  MemChunk* memChunk;
  short* ptr;
  short* endPtr;
  int len;
  

  if (audioInfo->getStereo()==false) {
    //cout << "mono volume not yet supported"<<endl;
    return;
  }

  float right=volumeInfoStream->getRightVolume() / 100.0;
  float left=volumeInfoStream->getLeftVolume() / 100.0;
  
  memChunk=audioStream->getAudioBuffer()->getMemChunk();
  if (memChunk == NULL) {
    return;
  }
  ptr=(short*)memChunk->getPtr();
  len=memChunk->getLen();
  
  // ptr is len of char. if we modify stereo we only need the half to process
  len=len/2;
  endPtr=ptr+len;

  while(endPtr != ptr){
    *ptr=(short)(right*(float)*ptr);
    ptr++;
    *ptr=(short)(left*(float)*ptr);
    ptr++;
  }

  // now we have filtered the stream, this means we really
  // changed the volume in software.
  // The volumeInfo in the stream must now be set to 100%
  // (each channel).
  // But the audioDevice monitors the change bit in the volumeInfo.
  // The changebit is controlled by the volumeDevice!
  // We change the volume to 50% but we must forward
  // the correct changebit of the volumeDevice. Otherwise
  // the audioDevice never/always (depending on the change bit)
  // initializes itsself never/always.

  int lChange=volumeInfoStream->getChange();
  volumeInfoStream->setVolume(70.0);
  volumeInfoStream->setChange(lChange);

}


  

  

