/*
  stores input sources and delivers them simultaneously (abstract class) 
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */





#ifndef __MULTIINPUTDEVICE_H
#define __MULTIINPUTDEVICE_H


#include <devices/outputDevice.h>
#include <deviceConfig/multiQueueFifo.h>
#include <graph/daisyChain.h>

/*
  This class manage for each input source a seperate fifo.
  It copies the data in the fifo and take care to block
  the streamproducer if the fifo may overfloat.
  <p>
  Then, if all sources have delivered their data the
  data is delivered to the writeOut method.
  <p>
  It is possible to set the MultiInputDevice in different
  dequeue modes. Eg. Often it is needed that all sources
  delivers data before further processing is usefull.
  (This avoids "clicks" or "drops" on not realtime algorithms)
  Then it blocks all sources and waits for the remaining source.
  The default is : no wait.It dequeues everytime it is
  possible. This is sufficient for fast cpus. And
  because it is (currently) not used for "critical" things
  it is a good default.
*/



class MultiInputDevice : public OutputDevice {

  MultiQueueFifo* multiQueueFifo;
  DeviceConfigArray* configArray;
  int lQueueChange;

 public:
  MultiInputDevice();
  ~MultiInputDevice();

  void removeLocks(StreamProducer* streamProducer);
  char* getNodeName();

  void writeIn(NodeDevice* source,DeviceConfig* config);
  void writeOut(DeviceConfigArray* buf);


 protected:
  void addSource(struct NodeDevice* source);
  void removeSource(struct NodeDevice* source); 

};

#endif  
