/*
  stores deviceConfigs.
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include <deviceConfig/deviceConfigArray.h>


DeviceConfigArray::DeviceConfigArray() {
  entries=0;
}


DeviceConfigArray::~DeviceConfigArray() {
}



void DeviceConfigArray::clear() {
  entries=0;
}



int DeviceConfigArray::getEntries() {
  return entries;
}

void DeviceConfigArray::setEntries(int entries) {
  this->entries=entries;
}


DeviceConfig* DeviceConfigArray::getDeviceConfigAt(int pos) {
  return confArray[pos];
}


void DeviceConfigArray::setDeviceConfigAt(int pos,DeviceConfig* buf) {
  confArray[pos]=buf;
}


int DeviceConfigArray::getMaximumMemChunkLen() {
  AudioStream* audioStream;
  AudioBuffer* audioBuffer;
  MemChunk* memChunk;
  DeviceConfig* config;
  int i;
  int maxLen=0;

  for(i=0;i<entries;i++) {
    config=getDeviceConfigAt(i);
    audioStream=config->getAudioStream();
    if (audioStream->isValid()) {
      audioBuffer=audioStream->getAudioBuffer();
      memChunk=audioBuffer->getMemChunk();
      if (memChunk != NULL) {
	if (memChunk->getLen() > maxLen) {
	  maxLen=memChunk->getLen();
	}
      }
    }
  }
  return maxLen;
}


int DeviceConfigArray::getMaximumMemChunkPos() {
  AudioStream* audioStream;
  AudioBuffer* audioBuffer;
  MemChunk* memChunk;
  DeviceConfig* config;
  int i;
  int maxPos=0;
  int maxLen=0;

  for(i=0;i<entries;i++) {
    config=getDeviceConfigAt(i);
    audioStream=config->getAudioStream();
    if (audioStream->isValid()) {   
      audioBuffer=audioStream->getAudioBuffer();
      memChunk=audioBuffer->getMemChunk();
      if (memChunk != NULL) {
	if (memChunk->getLen() > maxLen) {
	  maxPos=i;
	  maxLen=memChunk->getLen();
	}
      }
    }
  }
  return maxPos;
}


