/*
  Copyright (C) 1999 Rainer Maximini

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package
*/

#include <stdio.h>
#include <qstring.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <unistd.h>
#include <fcntl.h>
#include "kjukebox.h"
#include "mp3.h"
#include <iostream.h>
#include <qfileinfo.h> 

MP3::MP3(){
  config = (KApplication::getKApplication())->getConfig();
  tag = new Tag;
  layer = new Layer;
  format = "%t|%a|%l|%y|%c|%g|%#|%v|%L|%C|%b|%F|%M|%O|%o|%m|%s|%S|%f|%i";
  hastag = true;
  haslayer = true;
  filelength = 0;
  filename[0] = 0;
  hastag = false;
  haslayer = false;
}

MP3::~MP3(){
  if (filename[0] && file) fclose(file);
}

bool MP3::initfile(bool gettag=true){
  layer->setFileName(filename);
  if (!(layer->scan(file))) {
    haslayer = false;
    return (false);
  }
  haslayer = true;
  if (gettag)  hastag = tag->scan(file);
  if (!hastag) {
    config->setGroup(KCONFIG_MP3);
    if(!(config->readBoolEntry(KCONFIG_MP3_LOAD_WITHOUT_TAG,true)))
      return (false);
  }
  return (true);
}

bool MP3::openForSave(const char *fname){
  return open(fname, true);
}

bool MP3::open(const char *fname){
  return open(fname,false);
}

bool MP3::open(const char *fname, bool forSave){
  struct stat fi;

  hastag=false;
  haslayer=false;

  if (fname == 0) fname = filename;
  if (forSave)
    file = fopen(fname, "r+");
  else 
    file = fopen(fname, "r");
  if (file == 0) {
    perror("OPEN:");
    return (false);
  }

  tag->clear();
  fstat(fileno(file), &fi);
  filelength = fi.st_size;
  strncpy(filename, fname, FILENAME_LEN);
  return (true);
}

bool MP3::saveTags(){
  return tag->saveTags(file);
}

void MP3::close(){
  if (file) fclose(file);
  file = NULL;
}


Song MP3::getSong(){
  Song tmp;

  config->setGroup(KCONFIG_MP3);
  if(hastag){
    tmp.setTitle((QString)tag->title,false);
    tmp.setArtist((QString)tag->artist,false);
    tmp.setAlbum((QString)tag->album,false);
    tmp.setComment((QString)tag->comment,false);
    tmp.setGenre((QString)tag->genre,false);
    tmp.setGenreNum(tag->gennum,false);
    tmp.setYear(atoi(tag->year),false);
  }
  else {
    if (config->readBoolEntry(KCONFIG_MP3_LOAD_WITHOUT_TAG,true)) {
      QFileInfo file((QString)filename);
      tmp.setTitle(file.fileName(),false);
      tmp.setArtist(config->readEntry(KCONFIG_MP3_DEFAULT_ARTIST, i18n("Unknown")));
      tmp.setAlbum (config->readEntry(KCONFIG_MP3_DEFAULT_ALBUM,  i18n("Unknown")));
    }
  }
  tmp.setFilename((QString)filename,false);
  tmp.setStereomode((QString)layer->mode_name(),false);
  tmp.setPlayed(0,false);
  tmp.setSamplerate(layer->sfreq(),false);
  tmp.setBitrate(layer->bitrate(),false);
  tmp.setSize(filelength,false);
  tmp.setSeconds(layer->length() ,false);
  tmp.setLayer((QString)layer->layer_name(),true);
  tmp.checkForPlausibility((QString)filename);

  return tmp;
}


bool MP3::saveCommentTag(const char* fname, const char *comm){
  bool erg;
  if( openForSave(fname) ) {
    initfile();
    strncpy(tag->comment,comm,30);
    erg = saveTags();
    close();
    return erg;
  }
  return false;
}

bool MP3::saveTag(const char* fname, Tag mp3tag){
  bool erg;
  if( openForSave(fname) ) {
    initfile();
    strncpy(tag->comment,mp3tag.comment,30);
    strncpy(tag->title,  mp3tag.title,30);
    strncpy(tag->artist, mp3tag.artist,30);
    strncpy(tag->album,  mp3tag.album,30);
    strncpy(tag->year,   mp3tag.year,30);
    strcpy(tag->genre,mp3tag.genre);
    tag->gennum = mp3tag.gennum;
    erg = saveTags();
    close();
    return erg;
  }
  return false;
}
