/*
  Copyright (C) 1999 Rainer Maximini

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package
*/

#ifndef MAINWIDGET_H
#define MAINWIDGET_H

#include "../config.h"
#include "songList.h"
#include "songTree.h"
#include "configfolder.h"
#include "ioaccess.h"
#include "songInfo.h"
#include "database.h"

#include <ktmainwindow.h>
#include <kmenubar.h>
#include <kstatusbar.h>
#include <drag.h>
#include <qstring.h>
#include <qscrollbar.h>
#include <qsplitter.h>
#include <kpopmenu.h>


class MainWidget: public QWidget{
  Q_OBJECT
 private:
  SongTree     *datalist;
  SongList     *playlist;
  SongInfo     *mp3Info;
  KDNDDropZone *dropZoneDB;
  KDNDDropZone *dropZonePL;
  QSongList         allSongs;
  QSplitter    *splitter;
  KPopupMenu   *rightButtonMenu;
  DataBase     *dataBase;
  
  QSongList  drop(KDNDDropZone *);

 protected:
  void resizeEvent (QResizeEvent *);
  void keyPressEvent(QKeyEvent* e);

 public:
  MainWidget(QWidget *parent=0, const char *name=0);
  Song getFirstSongToPlay();
  Song getRandomSongToPlay();
  void setDataBase(DataBase *db);
  Song* getSelectedSongRef();
  SongList *getPlayList();

 signals:
  //  void dropAction(KDNDDropZone *);
  void playSong(Song *);

 public slots:
  void doubleClickDB();
  void doubleClickPL();
  void showMP3Info();
  void showMP3Info(Song);
  void copySongIntoPlayList();
  void copyAllSongsIntoPlayList();
  void removeSong();
  void setDisplayOrder(int mode);
  void refreshDataList();
  void dropPL(KDNDDropZone *);
  void dropDB(KDNDDropZone *);

  void removePlayedSongs();
  void clearPlayList();
  void playSelectedSong();  
  void toggleFocus();

  void findAndPlaySong(Song );
};

#endif //MAINWIDGET_H
