/*
  Copyright (C) 1999 Rainer Maximini

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package
*/

#ifndef LISTS_H
#define LISTS_H


#include "../config.h"
#include "kjukebox.h"
#include <kapp.h>
#include <qstring.h>
#include <qlist.h>
#include <qobject.h>

typedef QList<Song>          QSongListBase;
typedef QListIterator<Song>  QSongListIterator;
typedef QList<QString>       QGenreListBase;
typedef QString              Genre;

class QSongList : public QSongListBase{ 
 public:
};

class QSongListByArtist : public QSongList{
 protected:
  int compareItems ( GCI item1, GCI item2 );
};
class QSongListByTitle : public QSongList{
 protected:
  int compareItems ( GCI item1, GCI item2 );
};



/* class QGenreSet : public QGenreListBase, public QObject{ */
class QGenreSet : public QObject, public QGenreListBase {
  Q_OBJECT
 public:
  QGenreSet(QObject *parent=0, const char *name=0);
  ~QGenreSet();
  void insert(Genre genre);
  void insert(QSongList *list);
 protected:
  int find(Genre genre);
 signals:
  void changed();
};

#endif LISTS_H
