/*
  Copyright (C) 1999 Rainer Maximini

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package
*/

#include <kslider.h>
#include <stdlib.h>
#include "configPlayer.h"


ConfigPlayer::ConfigPlayer( QWidget *parent, const char *name )
  : QWidget( parent, name ){

  QString pp;
  
  config = (KApplication::getKApplication())->getConfig();  
  config->setGroup(KCONFIG_PLAYER);
  defaultTime     = config->readBoolEntry(KCONFIG_PLAYER_DEFAULTTIME,true);
  mixing          = config->readBoolEntry(KCONFIG_PLAYER_MIXING,true);
  lastSeconds     = config->readNumEntry(KCONFIG_PLAYER_LASTSECONDS,7);
  firstSeconds    = config->readNumEntry(KCONFIG_PLAYER_FIRSTSECONDS,0);
  fadeOut         = config->readBoolEntry(KCONFIG_PLAYER_FADEOUT,true);
  fadeOutDuration = config->readNumEntry( KCONFIG_PLAYER_FADEOUTDURATION,3000);
  fadeIn          = config->readBoolEntry(KCONFIG_PLAYER_FADEIN,true);
  fadeInDuration  = config->readNumEntry( KCONFIG_PLAYER_FADEINDURATION,3000);
  audioDevice     = config->readEntry(KCONFIG_PLAYER_DEVICE,"/dev/dsp");
  quality         = config->readNumEntry(KCONFIG_PLAYER_QUALITY, _MP3_DECODER);


  boxTime = new QGroupBox(i18n("Skip Time"), this, "boxtime" );  

  enableMixing = new QCheckBox(i18n("enable mixing"), boxTime, "mixing");
  enableMixing->setChecked(mixing);

  enableDefaultTime = new QCheckBox(i18n("alway use default settings"), boxTime, "defaultTime");
  enableDefaultTime->setChecked(defaultTime);

  firstSecBox = new KLined( boxTime, "first");
  firstSecBoxLabel = new QLabel(firstSecBox, i18n("first seconds to skip"), boxTime);
  pp.sprintf("%d",firstSeconds);
  firstSecBox->setText(pp);

  lastSecBox = new KLined( boxTime, "last");
  lastSecBoxLabel = new QLabel(lastSecBox, i18n("last seconds to skip"), boxTime);
  pp.sprintf("%d",lastSeconds);
  lastSecBox->setText(pp);

  enableFadeOut = new QCheckBox(i18n("enable fade out"), boxTime, "fadeOut");
  enableFadeOut->setChecked(fadeOut);
  fadeOutDurationBox = new KLined(boxTime, "fade");
  fadeOutDurationBoxLabel = new QLabel(fadeOutDurationBox, i18n("duration"), boxTime);
  pp.sprintf("%d",(fadeOutDuration/1000));
  fadeOutDurationBox->setText(pp);

  enableFadeIn = new QCheckBox(i18n("enable fade In"), boxTime, "fadeIn");
  enableFadeIn->setChecked(fadeIn);
  fadeInDurationBox = new KLined(boxTime, "fade");
  fadeInDurationBoxLabel = new QLabel(fadeInDurationBox, i18n("duration"), boxTime);
  pp.sprintf("%d",(fadeInDuration/1000));
  fadeInDurationBox->setText(pp);

  boxDevice = new QGroupBox(i18n("Device"), this, "boxdevice" );  
  audioDevBox = new KLined( boxDevice, "audio");
  audioDevBoxLabel = new QLabel(audioDevBox, i18n("Audio"), boxDevice);
  audioDevBox->setText(audioDevice);


  boxQuality = new QGroupBox( this, "PlayList" );
  boxQuality->setTitle( i18n("Quality") );

  downsampleQuality = new QCheckBox( boxQuality );
  downsampleQuality->setText( i18n("downsample") );  
  monoQuality = new QCheckBox( boxQuality );
  monoQuality->setText( i18n("mono") );


  switch(quality){
  case _MP3_DECODER: 
    downsampleQuality->setChecked(FALSE);
    monoQuality->setChecked(FALSE);
    break;
  case _MP3_DECODER_REALLY_BAD:
    downsampleQuality->setChecked(TRUE);
    monoQuality->setChecked(TRUE);
    break;
  case _MP3_DECODER_DOWNSAMPLE:
    downsampleQuality->setChecked(TRUE);
    monoQuality->setChecked(FALSE);
    break;
  case _MP3_DECODER_MONOSAMPLE:
    downsampleQuality->setChecked(FALSE);
    monoQuality->setChecked(TRUE);
    break;
  }

}


void ConfigPlayer::cancel(){
  config->setGroup(KCONFIG_PLAYER);
  QString pp;

  mixing          = config->readBoolEntry(KCONFIG_PLAYER_MIXING,true);
  fadeOut         = config->readBoolEntry(KCONFIG_PLAYER_FADEOUT,true);
  fadeOutDuration = config->readNumEntry( KCONFIG_PLAYER_FADEOUTDURATION,3000);
  fadeIn          = config->readBoolEntry(KCONFIG_PLAYER_FADEIN,true);
  fadeInDuration  = config->readNumEntry( KCONFIG_PLAYER_FADEINDURATION,3000);
  defaultTime     = config->readBoolEntry(KCONFIG_PLAYER_DEFAULTTIME,true);
  lastSeconds     = config->readNumEntry(KCONFIG_PLAYER_LASTSECONDS,3);
  firstSeconds    = config->readNumEntry(KCONFIG_PLAYER_FIRSTSECONDS,0);
  audioDevice     = config->readEntry(KCONFIG_PLAYER_DEVICE,"/dev/dsp");
  quality         = config->readNumEntry(KCONFIG_PLAYER_QUALITY, _MP3_DECODER);

  enableMixing      ->setChecked(mixing);
  enableFadeOut     ->setChecked(fadeOut);
  enableFadeIn      ->setChecked(fadeIn);
  enableDefaultTime ->setChecked(defaultTime);
  pp.sprintf("%d",firstSeconds);
  firstSecBox       ->setText(pp);
  pp.sprintf("%d",lastSeconds);
  lastSecBox        ->setText(pp);
  pp.sprintf("%d",(fadeOutDuration/1000));
  fadeOutDurationBox   ->setText(pp);
  pp.sprintf("%d",(fadeInDuration/1000));
  fadeInDurationBox   ->setText(pp);
  audioDevBox       ->setText(audioDevice);

  switch(quality){
  case _MP3_DECODER: 
    downsampleQuality->setChecked(FALSE);
    monoQuality->setChecked(FALSE);
    break;
  case _MP3_DECODER_REALLY_BAD:
    downsampleQuality->setChecked(TRUE);
    monoQuality->setChecked(TRUE);
    break;
  case _MP3_DECODER_DOWNSAMPLE:
    downsampleQuality->setChecked(TRUE);
    monoQuality->setChecked(FALSE);
    break;
  case _MP3_DECODER_MONOSAMPLE:
    downsampleQuality->setChecked(FALSE);
    monoQuality->setChecked(TRUE);
    break;
  }
}

void ConfigPlayer::accept(){
  config->setGroup(KCONFIG_PLAYER);
  
  mixing         = enableMixing ->isChecked();
  defaultTime    = enableDefaultTime->isChecked();
  firstSeconds   = atoi(firstSecBox->text());
  if (firstSeconds < 0) firstSeconds = 0;
  lastSeconds    = atoi(lastSecBox->text());
  if (lastSeconds  < 0) lastSeconds  = 0;
  fadeOut        = enableFadeOut->isChecked();
  fadeOutDuration  = atoi(fadeOutDurationBox->text())*1000;
  if (fadeOutDuration < 0) fadeOutDuration = 0;
  fadeIn        = enableFadeIn->isChecked();
  fadeInDuration  = atoi(fadeInDurationBox->text())*1000;
  if (fadeInDuration < 0) fadeInDuration = 0;
  audioDevice    = audioDevBox->text();


  quality = _MP3_DECODER;
  if(downsampleQuality->isChecked()){
    if(monoQuality->isChecked())
      quality = _MP3_DECODER_REALLY_BAD;
    else 
      quality = _MP3_DECODER_DOWNSAMPLE;
  }
  else {
    if(monoQuality->isChecked())
      quality = _MP3_DECODER_MONOSAMPLE;
  }


  if (audioDevice != config->readEntry(KCONFIG_PLAYER_DEVICE,"/dev/dsp")){
    config->writeEntry(KCONFIG_PLAYER_DEVICE,audioDevice);    
    emit audioDeviceChanged();
  }

  config->writeEntry(KCONFIG_PLAYER_MIXING,mixing);
  config->writeEntry(KCONFIG_PLAYER_FADEOUT,fadeOut);
  config->writeEntry(KCONFIG_PLAYER_FADEIN,fadeIn);
  config->writeEntry(KCONFIG_PLAYER_DEFAULTTIME,defaultTime);
  config->writeEntry(KCONFIG_PLAYER_FIRSTSECONDS,firstSeconds);
  config->writeEntry(KCONFIG_PLAYER_LASTSECONDS,lastSeconds);
  config->writeEntry(KCONFIG_PLAYER_FADEOUTDURATION,fadeOutDuration);
  config->writeEntry(KCONFIG_PLAYER_FADEINDURATION,fadeInDuration);
  config->writeEntry(KCONFIG_PLAYER_QUALITY, quality);
  config->sync();
}

void ConfigPlayer::resizeEvent( QResizeEvent * ){
  boxTime  ->setGeometry(10,10,width()-20,230);
  enableMixing        ->setGeometry( 10, 20, boxTime->width()-20, 25);
  enableDefaultTime   ->setGeometry( 10, 55, boxTime->width()-20, 25);
  firstSecBox         ->setGeometry( 10, 90, 40, 25);
  firstSecBoxLabel    ->setGeometry( 60, 90,boxTime->width()-70, 25);
  lastSecBox          ->setGeometry( 10,125, 40, 25);
  lastSecBoxLabel     ->setGeometry( 60,125,boxTime->width()-70, 25);

  enableFadeOut           ->setGeometry( 10,160, boxTime->width()-20, 25);
  fadeOutDurationBox      ->setGeometry( boxTime->width()-140,160, 40, 25);
  fadeOutDurationBoxLabel ->setGeometry( boxTime->width()-95,160,70, 25);
  enableFadeIn            ->setGeometry( 10,195, boxTime->width()-20, 25);
  fadeInDurationBox      ->setGeometry( boxTime->width()-140,195, 40, 25);
  fadeInDurationBoxLabel ->setGeometry( boxTime->width()-95,195,70, 25);

  boxDevice         ->setGeometry( 10,250,width()-20, 55);
  audioDevBoxLabel  ->setGeometry( 10, 20, 50, 25);
  audioDevBox       ->setGeometry( 70, 20,boxDevice->width()-80, 25);

  boxQuality        ->setGeometry( 10,315,width()-20, 70);
  downsampleQuality ->setGeometry( 10, 20, boxQuality->width()-20, 20);
  monoQuality       ->setGeometry( 10, 45, boxQuality->width()-20, 20);
}





