/*
  Copyright (C) 1999 Rainer Maximini

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package
*/

#include <kslider.h>
#include <stdlib.h>
#include "configGui.h"


ConfigGui::ConfigGui( QWidget *parent, const char *name )
  : QWidget( parent, name ){

  config = (KApplication::getKApplication())->getConfig();  
  config->setGroup(KCONFIG_GUI);

  int pl = config->readNumEntry(KCONFIG_GUI_DC_PLAYLIST,PLAYSONG);
  int db = config->readNumEntry(KCONFIG_GUI_DC_DATABASE,PLAYSONG);
  int pc = config->readNumEntry(KCONFIG_GUI_DECODER_CRASHED,AUTO_REPAIR_WITH_WARNING);

  dcDataBase = new QButtonGroup( this, "database" );
  dcDataBase->setTitle( i18n("Double click in database") );

  dcDBPlay = new QRadioButton( dcDataBase );
  dcDBPlay->setText( i18n("&play song immediately") );  
  dcDBInfo = new QRadioButton( dcDataBase );
  dcDBInfo->setText( i18n("&show song informations") );

  if(db == PLAYSONG) 
    dcDBPlay->setChecked( TRUE );
  else
    dcDBInfo->setChecked( TRUE );
    
  dcPlayList = new QButtonGroup( this, "PlayList" );
  dcPlayList->setTitle( i18n("Double click in playlist") );

  dcPLPlay = new QRadioButton( dcPlayList );
  dcPLPlay->setText( i18n("&play song immediately") );  
  dcPLInfo = new QRadioButton( dcPlayList );
  dcPLInfo->setText( i18n("&show song informations") );

  if(pl == PLAYSONG) 
    dcPLPlay->setChecked( TRUE );
  else
    dcPLInfo->setChecked( TRUE );

  playerCrashed  = new QButtonGroup( this, "PlayerCrashed" );
  playerCrashed->setTitle( i18n("Player Crash") );

  pcWithWarning  = new QRadioButton( playerCrashed );
  pcWithWarning->setText( i18n("auto repair &with warning") );  
  pcWithoutWarning  = new QRadioButton( playerCrashed );
  pcWithoutWarning->setText( i18n("auto repair with&out warning") );  
  switch(pc){
  case AUTO_REPAIR_WITHOUT_WARNING: pcWithoutWarning->setChecked( TRUE ); break;
  case AUTO_REPAIR_WITH_WARNING: pcWithWarning->setChecked( TRUE ); break;
  }

}


void ConfigGui::cancel(){
  config->setGroup(KCONFIG_GUI);

  if(config->readNumEntry(KCONFIG_GUI_DC_DATABASE,PLAYSONG) == PLAYSONG) 
    dcDBPlay->setChecked( TRUE );
  else
    dcDBInfo->setChecked( TRUE );
  
  if(config->readNumEntry(KCONFIG_GUI_DC_PLAYLIST,PLAYSONG) == PLAYSONG) 
    dcPLPlay->setChecked( TRUE );
  else
    dcPLInfo->setChecked( TRUE );

  switch(config->readNumEntry(KCONFIG_GUI_DECODER_CRASHED,AUTO_REPAIR_WITH_WARNING)){
  case AUTO_REPAIR_WITHOUT_WARNING: pcWithoutWarning->setChecked( TRUE ); break;
  case AUTO_REPAIR_WITH_WARNING: pcWithWarning->setChecked( TRUE ); break;
  }
}

void ConfigGui::accept(){
  config->setGroup(KCONFIG_GUI);

  if(dcDBPlay->isChecked())
    config->writeEntry(KCONFIG_GUI_DC_DATABASE,PLAYSONG);
  else
    config->writeEntry(KCONFIG_GUI_DC_DATABASE,SHOWSONG);

  if(dcPLPlay->isChecked())
    config->writeEntry(KCONFIG_GUI_DC_PLAYLIST,PLAYSONG);
  else
    config->writeEntry(KCONFIG_GUI_DC_PLAYLIST,SHOWSONG);

  int pc = 0;  
  if(pcWithWarning->isChecked()) pc = AUTO_REPAIR_WITH_WARNING;
  if(pcWithoutWarning->isChecked()) pc = AUTO_REPAIR_WITHOUT_WARNING;
  config->writeEntry(KCONFIG_GUI_DECODER_CRASHED,pc);

  config->sync();
}

void ConfigGui::resizeEvent( QResizeEvent * ){
  dcDataBase->setGeometry(10,10,width()-20,70);
  dcPlayList->setGeometry(10,90,width()-20,70);
  playerCrashed->setGeometry(10,170,width()-20,70);

  dcDBPlay->setGeometry( 10, 20, dcDataBase->width()-20, 20);
  dcDBInfo->setGeometry( 10, 45, dcDataBase->width()-20, 20);

  dcPLPlay->setGeometry( 10, 20, dcPlayList->width()-20, 20);
  dcPLInfo->setGeometry( 10, 45, dcPlayList->width()-20, 20);

  pcWithWarning->setGeometry( 10, 20, dcPlayList->width()-20, 20);
  pcWithoutWarning->setGeometry( 10, 45, dcPlayList->width()-20, 20);

}
