/*
  Interface to send messages from the gui to the thread
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */





#ifndef __THREAD_NOTIFIER_H
#define __THREAD_NOTIFIER_H

#include <pthread.h>

#include <iostream.h>


#define _MAX_THREAD_ENTRIES      10


// sync messages
#define _ALLOW_GENERATOR_ENTER        1
#define _NOT_ALLOW_GENERATOR_ENTER    2
#define _GENERATOR_CRASHED            7
#define _STOP_WORKING_BECAUSE_OF_EOF  8

typedef struct {
  int valid;
  int msg;
} ThreadEntry;


/**
  The ThreadNotify class is the "other" side from the EventQueue.
  The EventQueue is used to send data from the thread to the
  GUI. This class is used to send Data from the GUI to a thread.
  There are a few predefined messages. But you can send
  user defined messages as well.
  The predefined values are defines in statusInfo.
  (Playing,stopped, paused.)
  <p>
  General information:
  <p>
  This library has a concept of "producers" and "devices"
  Producers are implemented as a thread. Sometimes
  The user/GUI want to stop the thread or pause it.
  This must be stored somewhere. And what counts more
  that this state must be send to the right thread.
  <p>
  Eg. A fileDevice (which writes a stream to disk) must
  know when the stream reaches "eof".
  This means that the thread stops. Thus the thread must
  deliver a "stop" message to the connected listeners (devices)
  <p>
  A streamProducer derives from this class. A streamProducer
  works very closley together with a "producer".
  <pre>
  stupid name confusion : 
    
     streamProducer - a thread who _takes_ data from the producer
                      and _delivers_ data
     "producer"     - a interface class which _create_ data

  </pre>
  <p>
  The streamproducer enters the producer gets the data and then delivers
  the data.
  <p>
  There are two possibilities to send a thread a message. One
  methode is through a pipe. This is always possible. But you
  cannot be sure when the thread gets the message(asynchron). The other
  is only possible is the thread derives from this class.
  (Streamproducer does this). But even then you cannot
  call this method every time. The sendMutexMessage(..) is
  a synchron delivery. This means, that after this method
  returns the thread has "read" the message. This method
  is mutexed. This means that you may deadlock the program!

*/


class ThreadNotifier {

  ThreadEntry* threadEntryArray[_MAX_THREAD_ENTRIES];
  int freePos;
  int readPos;
  int fillgrade;
  pthread_mutex_t notifierMut;


 public:
  ThreadNotifier();
  virtual ~ThreadNotifier();

  virtual void sendSyncMessage(int msg);
  virtual void sendAsyncMessage(int msg);

  virtual int hasAsyncMessage();
  // after "getMessage" the message is delete from the queue
  virtual int getAsyncMessage();

  virtual void dumpThread();

};

#endif


