/*
  implements a directed stream graph
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include <graph/yafGraph.h>
#include "../../../../config.h"


YafGraph::YafGraph() {
  int i;
  for(i=0;i<_MAX_CONNECTION;i++) {
    connectTable[i]=new Connection();
    connectTable[i]->valid=false;
  }
}


YafGraph::~YafGraph() {
  int i;

  for(i=0;i<_MAX_CONNECTION;i++) {
    delete connectTable[i];
  }  
}


void YafGraph::connect(NodeDevice* source,NodeDevice* listener){
  int i;

  for(i=0;i<_MAX_CONNECTION;i++) {
    if (connectTable[i]->valid==false) {
      connectTable[i]->source=source;
      connectTable[i]->listener=listener;
      connectTable[i]->valid=true; 
      return;
    }
  }    
  debugOutput( cout << "maximum connections for this device reached! ->exiting"<<endl );
  exit(0);

  
}


void YafGraph::disconnect(NodeDevice* source,NodeDevice* listener){
  int i;
  Connection* connection;
  
  for(i=0;i<_MAX_CONNECTION;i++) {
    if (connectTable[i]->valid==true) {
      connection=connectTable[i];
      if ( (connection->source == source) && 
	   (connection->listener == listener) ) {
	connection->valid=false;
	return;
      }
    }
  }      
}


void YafGraph::getListeners(NodeDevice* source, Edges* edges){
  int i;
  Connection* connection;
  edges->clear();

  for(i=0;i<_MAX_CONNECTION;i++) {
    if (connectTable[i]->valid==true) {
      connection=connectTable[i];
      if (connection->source == source) {
	int pos=edges->getElements();
	edges->setNodeDevice(pos,connection->listener);
	edges->setElements(pos+1);
      }
    }
  }       
}


void YafGraph::getSources(NodeDevice* listener, Edges* edges){
  int i;
  Connection* connection;
  edges->clear();

  for(i=0;i<_MAX_CONNECTION;i++) {
    if (connectTable[i]->valid==true) {
      connection=connectTable[i];
      if (connection->listener == listener) {
	int pos=edges->getElements();
	edges->setNodeDevice(pos,connection->source);
	edges->setElements(pos+1);
      }
    }
  }         
}


